<?php

namespace EnumType;

/**
 * This class stands for PromosyonSatirlariAktarimTip EnumType
 * @subpackage Enumerations
 */
class PromosyonSatirlariAktarimTip
{
    /**
     * Constant for value 'Satir'
     * @return string 'Satir'
     */
    const VALUE_SATIR = 'Satir';
    /**
     * Constant for value 'FaturaAlti'
     * @return string 'FaturaAlti'
     */
    const VALUE_FATURA_ALTI = 'FaturaAlti';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SATIR
     * @uses self::VALUE_FATURA_ALTI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SATIR,
            self::VALUE_FATURA_ALTI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
