<?php

namespace EnumType;

/**
 * This class stands for clsResultExceptionCode EnumType
 * @subpackage Enumerations
 */
class ClsResultExceptionCode
{
    /**
     * Constant for value 'HerseyOkey'
     * @return string 'HerseyOkey'
     */
    const VALUE_HERSEY_OKEY = 'HerseyOkey';
    /**
     * Constant for value 'SeriLotBaslangicGirilmedi'
     * @return string 'SeriLotBaslangicGirilmedi'
     */
    const VALUE_SERI_LOT_BASLANGIC_GIRILMEDI = 'SeriLotBaslangicGirilmedi';
    /**
     * Constant for value 'SeriLotBitisGirilmedi'
     * @return string 'SeriLotBitisGirilmedi'
     */
    const VALUE_SERI_LOT_BITIS_GIRILMEDI = 'SeriLotBitisGirilmedi';
    /**
     * Constant for value 'SeriLotBitisBaslangictanBuyuk'
     * @return string 'SeriLotBitisBaslangictanBuyuk'
     */
    const VALUE_SERI_LOT_BITIS_BASLANGICTAN_BUYUK = 'SeriLotBitisBaslangictanBuyuk';
    /**
     * Constant for value 'SeriLotOncedenCikmis'
     * @return string 'SeriLotOncedenCikmis'
     */
    const VALUE_SERI_LOT_ONCEDEN_CIKMIS = 'SeriLotOncedenCikmis';
    /**
     * Constant for value 'SeriLotDepodaYok'
     * @return string 'SeriLotDepodaYok'
     */
    const VALUE_SERI_LOT_DEPODA_YOK = 'SeriLotDepodaYok';
    /**
     * Constant for value 'SeriLotHareketGormus'
     * @return string 'SeriLotHareketGormus'
     */
    const VALUE_SERI_LOT_HAREKET_GORMUS = 'SeriLotHareketGormus';
    /**
     * Constant for value 'SeriLotCikmamis'
     * @return string 'SeriLotCikmamis'
     */
    const VALUE_SERI_LOT_CIKMAMIS = 'SeriLotCikmamis';
    /**
     * Constant for value 'StokYetersiz'
     * @return string 'StokYetersiz'
     */
    const VALUE_STOK_YETERSIZ = 'StokYetersiz';
    /**
     * Constant for value 'AyKapaniGunu'
     * @return string 'AyKapaniGunu'
     */
    const VALUE_AY_KAPANI_GUNU = 'AyKapaniGunu';
    /**
     * Constant for value 'AktifGunSayisi'
     * @return string 'AktifGunSayisi'
     */
    const VALUE_AKTIF_GUN_SAYISI = 'AktifGunSayisi';
    /**
     * Constant for value 'BelgeKotaAltLimiti'
     * @return string 'BelgeKotaAltLimiti'
     */
    const VALUE_BELGE_KOTA_ALT_LIMITI = 'BelgeKotaAltLimiti';
    /**
     * Constant for value 'BelgeKotaUstLimiti'
     * @return string 'BelgeKotaUstLimiti'
     */
    const VALUE_BELGE_KOTA_UST_LIMITI = 'BelgeKotaUstLimiti';
    /**
     * Constant for value 'BelgeKotaGun'
     * @return string 'BelgeKotaGun'
     */
    const VALUE_BELGE_KOTA_GUN = 'BelgeKotaGun';
    /**
     * Constant for value 'BelgeKotaHafta'
     * @return string 'BelgeKotaHafta'
     */
    const VALUE_BELGE_KOTA_HAFTA = 'BelgeKotaHafta';
    /**
     * Constant for value 'BelgeKotaAy'
     * @return string 'BelgeKotaAy'
     */
    const VALUE_BELGE_KOTA_AY = 'BelgeKotaAy';
    /**
     * Constant for value 'SecilmeyenVeyaliIskPro'
     * @return string 'SecilmeyenVeyaliIskPro'
     */
    const VALUE_SECILMEYEN_VEYALI_ISK_PRO = 'SecilmeyenVeyaliIskPro';
    /**
     * Constant for value 'BirdenFazlaSecilmisVeyaliIskPro'
     * @return string 'BirdenFazlaSecilmisVeyaliIskPro'
     */
    const VALUE_BIRDEN_FAZLA_SECILMIS_VEYALI_ISK_PRO = 'BirdenFazlaSecilmisVeyaliIskPro';
    /**
     * Constant for value 'GruplardaMiktarTutarsizIskPro'
     * @return string 'GruplardaMiktarTutarsizIskPro'
     */
    const VALUE_GRUPLARDA_MIKTAR_TUTARSIZ_ISK_PRO = 'GruplardaMiktarTutarsizIskPro';
    /**
     * Constant for value 'AyniMusteriFarkliYuklemeler'
     * @return string 'AyniMusteriFarkliYuklemeler'
     */
    const VALUE_AYNI_MUSTERI_FARKLI_YUKLEMELER = 'AyniMusteriFarkliYuklemeler';
    /**
     * Constant for value 'FaturalastirmaYapilamadi'
     * @return string 'FaturalastirmaYapilamadi'
     */
    const VALUE_FATURALASTIRMA_YAPILAMADI = 'FaturalastirmaYapilamadi';
    /**
     * Constant for value 'IrsaliyelestirmeYapilamadi'
     * @return string 'IrsaliyelestirmeYapilamadi'
     */
    const VALUE_IRSALIYELESTIRME_YAPILAMADI = 'IrsaliyelestirmeYapilamadi';
    /**
     * Constant for value 'SevkiyatIskontoPromosyonSecim'
     * @return string 'SevkiyatIskontoPromosyonSecim'
     */
    const VALUE_SEVKIYAT_ISKONTO_PROMOSYON_SECIM = 'SevkiyatIskontoPromosyonSecim';
    /**
     * Constant for value 'SevkiyatSevkTarihiKontrolu'
     * @return string 'SevkiyatSevkTarihiKontrolu'
     */
    const VALUE_SEVKIYAT_SEVK_TARIHI_KONTROLU = 'SevkiyatSevkTarihiKontrolu';
    /**
     * Constant for value 'RuhsatNoYok'
     * @return string 'RuhsatNoYok'
     */
    const VALUE_RUHSAT_NO_YOK = 'RuhsatNoYok';
    /**
     * Constant for value 'SifirTutarliBelge'
     * @return string 'SifirTutarliBelge'
     */
    const VALUE_SIFIR_TUTARLI_BELGE = 'SifirTutarliBelge';
    /**
     * Constant for value 'SecilmeyenCakisanIskPro'
     * @return string 'SecilmeyenCakisanIskPro'
     */
    const VALUE_SECILMEYEN_CAKISAN_ISK_PRO = 'SecilmeyenCakisanIskPro';
    /**
     * Constant for value 'MukerrerMatbuNo'
     * @return string 'MukerrerMatbuNo'
     */
    const VALUE_MUKERRER_MATBU_NO = 'MukerrerMatbuNo';
    /**
     * Constant for value 'KrediLimitiYetersiz'
     * @return string 'KrediLimitiYetersiz'
     */
    const VALUE_KREDI_LIMITI_YETERSIZ = 'KrediLimitiYetersiz';
    /**
     * Constant for value 'PromosyonTutariGecildi'
     * @return string 'PromosyonTutariGecildi'
     */
    const VALUE_PROMOSYON_TUTARI_GECILDI = 'PromosyonTutariGecildi';
    /**
     * Constant for value 'TahsilatTutarKontrolu'
     * @return string 'TahsilatTutarKontrolu'
     */
    const VALUE_TAHSILAT_TUTAR_KONTROLU = 'TahsilatTutarKontrolu';
    /**
     * Constant for value 'MusteriAitYuklemeFarkliAractaVar'
     * @return string 'MusteriAitYuklemeFarkliAractaVar'
     */
    const VALUE_MUSTERI_AIT_YUKLEME_FARKLI_ARACTA_VAR = 'MusteriAitYuklemeFarkliAractaVar';
    /**
     * Constant for value 'BelgeTarihlerindeBirYilKontrolu'
     * @return string 'BelgeTarihlerindeBirYilKontrolu'
     */
    const VALUE_BELGE_TARIHLERINDE_BIR_YIL_KONTROLU = 'BelgeTarihlerindeBirYilKontrolu';
    /**
     * Constant for value 'AktarilanBelge'
     * @return string 'AktarilanBelge'
     */
    const VALUE_AKTARILAN_BELGE = 'AktarilanBelge';
    /**
     * Constant for value 'FaturaGecikme'
     * @return string 'FaturaGecikme'
     */
    const VALUE_FATURA_GECIKME = 'FaturaGecikme';
    /**
     * Constant for value 'SIFkontrol'
     * @return string 'SIFkontrol'
     */
    const VALUE_SIFKONTROL = 'SIFkontrol';
    /**
     * Constant for value 'IleriTarihAktifGunSayisi'
     * @return string 'IleriTarihAktifGunSayisi'
     */
    const VALUE_ILERI_TARIH_AKTIF_GUN_SAYISI = 'IleriTarihAktifGunSayisi';
    /**
     * Constant for value 'MinBrutTutarKontrolu'
     * @return string 'MinBrutTutarKontrolu'
     */
    const VALUE_MIN_BRUT_TUTAR_KONTROLU = 'MinBrutTutarKontrolu';
    /**
     * Constant for value 'SecilmeyenKodBazindaIskPro'
     * @return string 'SecilmeyenKodBazindaIskPro'
     */
    const VALUE_SECILMEYEN_KOD_BAZINDA_ISK_PRO = 'SecilmeyenKodBazindaIskPro';
    /**
     * Constant for value 'ZorunluEkSaha'
     * @return string 'ZorunluEkSaha'
     */
    const VALUE_ZORUNLU_EK_SAHA = 'ZorunluEkSaha';
    /**
     * Constant for value 'MerkezMustExcp'
     * @return string 'MerkezMustExcp'
     */
    const VALUE_MERKEZ_MUST_EXCP = 'MerkezMustExcp';
    /**
     * Constant for value 'IadeGirisLimit'
     * @return string 'IadeGirisLimit'
     */
    const VALUE_IADE_GIRIS_LIMIT = 'IadeGirisLimit';
    /**
     * Constant for value 'MusteriRiskKontrol'
     * @return string 'MusteriRiskKontrol'
     */
    const VALUE_MUSTERI_RISK_KONTROL = 'MusteriRiskKontrol';
    /**
     * Constant for value 'DistLimitKontrol'
     * @return string 'DistLimitKontrol'
     */
    const VALUE_DIST_LIMIT_KONTROL = 'DistLimitKontrol';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HERSEY_OKEY
     * @uses self::VALUE_SERI_LOT_BASLANGIC_GIRILMEDI
     * @uses self::VALUE_SERI_LOT_BITIS_GIRILMEDI
     * @uses self::VALUE_SERI_LOT_BITIS_BASLANGICTAN_BUYUK
     * @uses self::VALUE_SERI_LOT_ONCEDEN_CIKMIS
     * @uses self::VALUE_SERI_LOT_DEPODA_YOK
     * @uses self::VALUE_SERI_LOT_HAREKET_GORMUS
     * @uses self::VALUE_SERI_LOT_CIKMAMIS
     * @uses self::VALUE_STOK_YETERSIZ
     * @uses self::VALUE_AY_KAPANI_GUNU
     * @uses self::VALUE_AKTIF_GUN_SAYISI
     * @uses self::VALUE_BELGE_KOTA_ALT_LIMITI
     * @uses self::VALUE_BELGE_KOTA_UST_LIMITI
     * @uses self::VALUE_BELGE_KOTA_GUN
     * @uses self::VALUE_BELGE_KOTA_HAFTA
     * @uses self::VALUE_BELGE_KOTA_AY
     * @uses self::VALUE_SECILMEYEN_VEYALI_ISK_PRO
     * @uses self::VALUE_BIRDEN_FAZLA_SECILMIS_VEYALI_ISK_PRO
     * @uses self::VALUE_GRUPLARDA_MIKTAR_TUTARSIZ_ISK_PRO
     * @uses self::VALUE_AYNI_MUSTERI_FARKLI_YUKLEMELER
     * @uses self::VALUE_FATURALASTIRMA_YAPILAMADI
     * @uses self::VALUE_IRSALIYELESTIRME_YAPILAMADI
     * @uses self::VALUE_SEVKIYAT_ISKONTO_PROMOSYON_SECIM
     * @uses self::VALUE_SEVKIYAT_SEVK_TARIHI_KONTROLU
     * @uses self::VALUE_RUHSAT_NO_YOK
     * @uses self::VALUE_SIFIR_TUTARLI_BELGE
     * @uses self::VALUE_SECILMEYEN_CAKISAN_ISK_PRO
     * @uses self::VALUE_MUKERRER_MATBU_NO
     * @uses self::VALUE_KREDI_LIMITI_YETERSIZ
     * @uses self::VALUE_PROMOSYON_TUTARI_GECILDI
     * @uses self::VALUE_TAHSILAT_TUTAR_KONTROLU
     * @uses self::VALUE_MUSTERI_AIT_YUKLEME_FARKLI_ARACTA_VAR
     * @uses self::VALUE_BELGE_TARIHLERINDE_BIR_YIL_KONTROLU
     * @uses self::VALUE_AKTARILAN_BELGE
     * @uses self::VALUE_FATURA_GECIKME
     * @uses self::VALUE_SIFKONTROL
     * @uses self::VALUE_ILERI_TARIH_AKTIF_GUN_SAYISI
     * @uses self::VALUE_MIN_BRUT_TUTAR_KONTROLU
     * @uses self::VALUE_SECILMEYEN_KOD_BAZINDA_ISK_PRO
     * @uses self::VALUE_ZORUNLU_EK_SAHA
     * @uses self::VALUE_MERKEZ_MUST_EXCP
     * @uses self::VALUE_IADE_GIRIS_LIMIT
     * @uses self::VALUE_MUSTERI_RISK_KONTROL
     * @uses self::VALUE_DIST_LIMIT_KONTROL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HERSEY_OKEY,
            self::VALUE_SERI_LOT_BASLANGIC_GIRILMEDI,
            self::VALUE_SERI_LOT_BITIS_GIRILMEDI,
            self::VALUE_SERI_LOT_BITIS_BASLANGICTAN_BUYUK,
            self::VALUE_SERI_LOT_ONCEDEN_CIKMIS,
            self::VALUE_SERI_LOT_DEPODA_YOK,
            self::VALUE_SERI_LOT_HAREKET_GORMUS,
            self::VALUE_SERI_LOT_CIKMAMIS,
            self::VALUE_STOK_YETERSIZ,
            self::VALUE_AY_KAPANI_GUNU,
            self::VALUE_AKTIF_GUN_SAYISI,
            self::VALUE_BELGE_KOTA_ALT_LIMITI,
            self::VALUE_BELGE_KOTA_UST_LIMITI,
            self::VALUE_BELGE_KOTA_GUN,
            self::VALUE_BELGE_KOTA_HAFTA,
            self::VALUE_BELGE_KOTA_AY,
            self::VALUE_SECILMEYEN_VEYALI_ISK_PRO,
            self::VALUE_BIRDEN_FAZLA_SECILMIS_VEYALI_ISK_PRO,
            self::VALUE_GRUPLARDA_MIKTAR_TUTARSIZ_ISK_PRO,
            self::VALUE_AYNI_MUSTERI_FARKLI_YUKLEMELER,
            self::VALUE_FATURALASTIRMA_YAPILAMADI,
            self::VALUE_IRSALIYELESTIRME_YAPILAMADI,
            self::VALUE_SEVKIYAT_ISKONTO_PROMOSYON_SECIM,
            self::VALUE_SEVKIYAT_SEVK_TARIHI_KONTROLU,
            self::VALUE_RUHSAT_NO_YOK,
            self::VALUE_SIFIR_TUTARLI_BELGE,
            self::VALUE_SECILMEYEN_CAKISAN_ISK_PRO,
            self::VALUE_MUKERRER_MATBU_NO,
            self::VALUE_KREDI_LIMITI_YETERSIZ,
            self::VALUE_PROMOSYON_TUTARI_GECILDI,
            self::VALUE_TAHSILAT_TUTAR_KONTROLU,
            self::VALUE_MUSTERI_AIT_YUKLEME_FARKLI_ARACTA_VAR,
            self::VALUE_BELGE_TARIHLERINDE_BIR_YIL_KONTROLU,
            self::VALUE_AKTARILAN_BELGE,
            self::VALUE_FATURA_GECIKME,
            self::VALUE_SIFKONTROL,
            self::VALUE_ILERI_TARIH_AKTIF_GUN_SAYISI,
            self::VALUE_MIN_BRUT_TUTAR_KONTROLU,
            self::VALUE_SECILMEYEN_KOD_BAZINDA_ISK_PRO,
            self::VALUE_ZORUNLU_EK_SAHA,
            self::VALUE_MERKEZ_MUST_EXCP,
            self::VALUE_IADE_GIRIS_LIMIT,
            self::VALUE_MUSTERI_RISK_KONTROL,
            self::VALUE_DIST_LIMIT_KONTROL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
