<?php

namespace EnumType;

/**
 * This class stands for clsERBelgeSonucTip EnumType
 * @subpackage Enumerations
 */
class ClsERBelgeSonucTip
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'WARNING'
     * @return string 'WARNING'
     */
    const VALUE_WARNING = 'WARNING';
    /**
     * Constant for value 'EXCEPTION'
     * @return string 'EXCEPTION'
     */
    const VALUE_EXCEPTION = 'EXCEPTION';
    /**
     * Constant for value 'YesNoQuestion'
     * @return string 'YesNoQuestion'
     */
    const VALUE_YES_NO_QUESTION = 'YesNoQuestion';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_EXCEPTION
     * @uses self::VALUE_YES_NO_QUESTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_WARNING,
            self::VALUE_EXCEPTION,
            self::VALUE_YES_NO_QUESTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
