<?php

namespace WebIT\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TransactionType EnumType
 * @subpackage Enumerations
 * @author Fahad Yousaf Mahar
 * @url    https
 */
class TransactionType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OTC'
     * @return string 'OTC'
     */
    const VALUE_OTC = 'OTC';
    /**
     * Constant for value 'MA'
     * @return string 'MA'
     */
    const VALUE_MA = 'MA';
    /**
     * Constant for value 'ATM'
     * @return string 'ATM'
     */
    const VALUE_ATM = 'ATM';
    /**
     * Constant for value 'CC'
     * @return string 'CC'
     */
    const VALUE_CC = 'CC';
    /**
     * Return allowed values
     * @uses self::VALUE_OTC
     * @uses self::VALUE_MA
     * @uses self::VALUE_ATM
     * @uses self::VALUE_CC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTC,
            self::VALUE_MA,
            self::VALUE_ATM,
            self::VALUE_CC,
        );
    }
}
