<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetScenario operation/method
 */
if ($get->GetScenario(new \StructType\GetScenario()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login(new \StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for Logout operation/method
 */
if ($logout->Logout(new \StructType\Logout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetBusinessDate operation/method
 */
if ($set->SetBusinessDate(new \StructType\SetBusinessDate()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetLocaleName operation/method
 */
if ($set->SetLocaleName(new \StructType\SetLocaleName()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSchemaMode operation/method
 */
if ($set->SetSchemaMode(new \StructType\SetSchemaMode()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for SOC ServiceType
 */
$sOC = new \ServiceType\SOC($options);
/**
 * Sample call for SO641010Clear operation/method
 */
if ($sOC->SO641010Clear(new \StructType\SO641010Clear()) !== false) {
    print_r($sOC->getResult());
} else {
    print_r($sOC->getLastError());
}
/**
 * Samples for SOG ServiceType
 */
$sOG = new \ServiceType\SOG($options);
/**
 * Sample call for SO641010GetProcessStatus operation/method
 */
if ($sOG->SO641010GetProcessStatus(new \StructType\SO641010GetProcessStatus()) !== false) {
    print_r($sOG->getResult());
} else {
    print_r($sOG->getLastError());
}
/**
 * Sample call for SO641010GetSchema operation/method
 */
if ($sOG->SO641010GetSchema(new \StructType\SO641010GetSchema()) !== false) {
    print_r($sOG->getResult());
} else {
    print_r($sOG->getLastError());
}
/**
 * Samples for SOS ServiceType
 */
$sOS = new \ServiceType\SOS($options);
/**
 * Sample call for SO641010SetSchema operation/method
 */
if ($sOS->SO641010SetSchema(new \StructType\SO641010SetSchema()) !== false) {
    print_r($sOS->getResult());
} else {
    print_r($sOS->getLastError());
}
/**
 * Sample call for SO641010Submit operation/method
 */
if ($sOS->SO641010Submit(new \StructType\SO641010Submit()) !== false) {
    print_r($sOS->getResult());
} else {
    print_r($sOS->getLastError());
}
/**
 * Samples for SOE ServiceType
 */
$sOE = new \ServiceType\SOE($options);
/**
 * Sample call for SO641010Export operation/method
 */
if ($sOE->SO641010Export(new \StructType\SO641010Export()) !== false) {
    print_r($sOE->getResult());
} else {
    print_r($sOE->getLastError());
}
/**
 * Samples for SOI ServiceType
 */
$sOI = new \ServiceType\SOI($options);
/**
 * Sample call for SO641010Import operation/method
 */
if ($sOI->SO641010Import(new \StructType\SO641010Import()) !== false) {
    print_r($sOI->getResult());
} else {
    print_r($sOI->getLastError());
}
