<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSchemaMode StructType
 * @subpackage Structs
 */
class SetSchemaMode extends AbstractStructBase
{
    /**
     * The mode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $mode;
    /**
     * Constructor method for SetSchemaMode
     * @uses SetSchemaMode::setMode()
     * @param string $mode
     */
    public function __construct($mode = null)
    {
        $this
            ->setMode($mode);
    }
    /**
     * Get mode value
     * @return string
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @uses \EnumType\SchemaMode::valueIsValid()
     * @uses \EnumType\SchemaMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return \StructType\SetSchemaMode
     */
    public function setMode($mode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SchemaMode::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SchemaMode', is_array($mode) ? implode(', ', $mode) : var_export($mode, true), implode(', ', \EnumType\SchemaMode::getValidValues())), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetSchemaMode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
