<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO641010Parameters StructType
 * @subpackage Structs
 */
class SO641010Parameters extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNumber;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SO641010ParametersServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for SO641010Parameters
     * @uses SO641010Parameters::setDisplayName()
     * @uses SO641010Parameters::setOrderType()
     * @uses SO641010Parameters::setOrderNumber()
     * @uses SO641010Parameters::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNumber
     * @param \StructType\SO641010ParametersServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $orderType = null, \StructType\Field $orderNumber = null, \StructType\SO641010ParametersServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setOrderType($orderType)
            ->setOrderNumber($orderNumber)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\SO641010Parameters
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\SO641010Parameters
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return \StructType\Field|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param \StructType\Field $orderNumber
     * @return \StructType\SO641010Parameters
     */
    public function setOrderNumber(\StructType\Field $orderNumber = null)
    {
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SO641010ParametersServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SO641010ParametersServiceCommands $serviceCommands
     * @return \StructType\SO641010Parameters
     */
    public function setServiceCommands(\StructType\SO641010ParametersServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO641010Parameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
