<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO641010ImportResult StructType
 * @subpackage Structs
 */
class SO641010ImportResult extends AbstractStructBase
{
    /**
     * The Processed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Processed;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Error;
    /**
     * Constructor method for SO641010ImportResult
     * @uses SO641010ImportResult::setProcessed()
     * @uses SO641010ImportResult::setError()
     * @param bool $processed
     * @param string $error
     */
    public function __construct($processed = null, $error = null)
    {
        $this
            ->setProcessed($processed)
            ->setError($error);
    }
    /**
     * Get Processed value
     * @return bool
     */
    public function getProcessed()
    {
        return $this->Processed;
    }
    /**
     * Set Processed value
     * @param bool $processed
     * @return \StructType\SO641010ImportResult
     */
    public function setProcessed($processed = null)
    {
        // validation for constraint: boolean
        if (!is_null($processed) && !is_bool($processed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($processed, true), gettype($processed)), __LINE__);
        }
        $this->Processed = $processed;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \StructType\SO641010ImportResult
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO641010ImportResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
