<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO641010Export StructType
 * @subpackage Structs
 */
class SO641010Export extends AbstractStructBase
{
    /**
     * The topCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $topCount;
    /**
     * The includeHeaders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeHeaders;
    /**
     * The breakOnError
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $breakOnError;
    /**
     * The commands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommand
     */
    public $commands;
    /**
     * The filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFilter
     */
    public $filters;
    /**
     * Constructor method for SO641010Export
     * @uses SO641010Export::setTopCount()
     * @uses SO641010Export::setIncludeHeaders()
     * @uses SO641010Export::setBreakOnError()
     * @uses SO641010Export::setCommands()
     * @uses SO641010Export::setFilters()
     * @param int $topCount
     * @param bool $includeHeaders
     * @param bool $breakOnError
     * @param \ArrayType\ArrayOfCommand $commands
     * @param \ArrayType\ArrayOfFilter $filters
     */
    public function __construct($topCount = null, $includeHeaders = null, $breakOnError = null, \ArrayType\ArrayOfCommand $commands = null, \ArrayType\ArrayOfFilter $filters = null)
    {
        $this
            ->setTopCount($topCount)
            ->setIncludeHeaders($includeHeaders)
            ->setBreakOnError($breakOnError)
            ->setCommands($commands)
            ->setFilters($filters);
    }
    /**
     * Get topCount value
     * @return int
     */
    public function getTopCount()
    {
        return $this->topCount;
    }
    /**
     * Set topCount value
     * @param int $topCount
     * @return \StructType\SO641010Export
     */
    public function setTopCount($topCount = null)
    {
        // validation for constraint: int
        if (!is_null($topCount) && !(is_int($topCount) || ctype_digit($topCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($topCount, true), gettype($topCount)), __LINE__);
        }
        $this->topCount = $topCount;
        return $this;
    }
    /**
     * Get includeHeaders value
     * @return bool
     */
    public function getIncludeHeaders()
    {
        return $this->includeHeaders;
    }
    /**
     * Set includeHeaders value
     * @param bool $includeHeaders
     * @return \StructType\SO641010Export
     */
    public function setIncludeHeaders($includeHeaders = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeHeaders) && !is_bool($includeHeaders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeHeaders, true), gettype($includeHeaders)), __LINE__);
        }
        $this->includeHeaders = $includeHeaders;
        return $this;
    }
    /**
     * Get breakOnError value
     * @return bool
     */
    public function getBreakOnError()
    {
        return $this->breakOnError;
    }
    /**
     * Set breakOnError value
     * @param bool $breakOnError
     * @return \StructType\SO641010Export
     */
    public function setBreakOnError($breakOnError = null)
    {
        // validation for constraint: boolean
        if (!is_null($breakOnError) && !is_bool($breakOnError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($breakOnError, true), gettype($breakOnError)), __LINE__);
        }
        $this->breakOnError = $breakOnError;
        return $this;
    }
    /**
     * Get commands value
     * @return \ArrayType\ArrayOfCommand|null
     */
    public function getCommands()
    {
        return $this->commands;
    }
    /**
     * Set commands value
     * @param \ArrayType\ArrayOfCommand $commands
     * @return \StructType\SO641010Export
     */
    public function setCommands(\ArrayType\ArrayOfCommand $commands = null)
    {
        $this->commands = $commands;
        return $this;
    }
    /**
     * Get filters value
     * @return \ArrayType\ArrayOfFilter|null
     */
    public function getFilters()
    {
        return $this->filters;
    }
    /**
     * Set filters value
     * @param \ArrayType\ArrayOfFilter $filters
     * @return \StructType\SO641010Export
     */
    public function setFilters(\ArrayType\ArrayOfFilter $filters = null)
    {
        $this->filters = $filters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO641010Export
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
