<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO641010CommonSettings StructType
 * @subpackage Structs
 */
class SO641010CommonSettings extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ViewPdf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ViewPdf;
    /**
     * The PdfCompressed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PdfCompressed;
    /**
     * The PdfFontEmbedded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PdfFontEmbedded;
    /**
     * The AlternativeEngine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AlternativeEngine;
    /**
     * The PrintAllPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PrintAllPages;
    /**
     * The DeletedRecords
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DeletedRecords;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SO641010CommonSettingsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for SO641010CommonSettings
     * @uses SO641010CommonSettings::setDisplayName()
     * @uses SO641010CommonSettings::setViewPdf()
     * @uses SO641010CommonSettings::setPdfCompressed()
     * @uses SO641010CommonSettings::setPdfFontEmbedded()
     * @uses SO641010CommonSettings::setAlternativeEngine()
     * @uses SO641010CommonSettings::setPrintAllPages()
     * @uses SO641010CommonSettings::setDeletedRecords()
     * @uses SO641010CommonSettings::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $viewPdf
     * @param \StructType\Field $pdfCompressed
     * @param \StructType\Field $pdfFontEmbedded
     * @param \StructType\Field $alternativeEngine
     * @param \StructType\Field $printAllPages
     * @param \StructType\Field $deletedRecords
     * @param \StructType\SO641010CommonSettingsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $viewPdf = null, \StructType\Field $pdfCompressed = null, \StructType\Field $pdfFontEmbedded = null, \StructType\Field $alternativeEngine = null, \StructType\Field $printAllPages = null, \StructType\Field $deletedRecords = null, \StructType\SO641010CommonSettingsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setViewPdf($viewPdf)
            ->setPdfCompressed($pdfCompressed)
            ->setPdfFontEmbedded($pdfFontEmbedded)
            ->setAlternativeEngine($alternativeEngine)
            ->setPrintAllPages($printAllPages)
            ->setDeletedRecords($deletedRecords)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\SO641010CommonSettings
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ViewPdf value
     * @return \StructType\Field|null
     */
    public function getViewPdf()
    {
        return $this->ViewPdf;
    }
    /**
     * Set ViewPdf value
     * @param \StructType\Field $viewPdf
     * @return \StructType\SO641010CommonSettings
     */
    public function setViewPdf(\StructType\Field $viewPdf = null)
    {
        $this->ViewPdf = $viewPdf;
        return $this;
    }
    /**
     * Get PdfCompressed value
     * @return \StructType\Field|null
     */
    public function getPdfCompressed()
    {
        return $this->PdfCompressed;
    }
    /**
     * Set PdfCompressed value
     * @param \StructType\Field $pdfCompressed
     * @return \StructType\SO641010CommonSettings
     */
    public function setPdfCompressed(\StructType\Field $pdfCompressed = null)
    {
        $this->PdfCompressed = $pdfCompressed;
        return $this;
    }
    /**
     * Get PdfFontEmbedded value
     * @return \StructType\Field|null
     */
    public function getPdfFontEmbedded()
    {
        return $this->PdfFontEmbedded;
    }
    /**
     * Set PdfFontEmbedded value
     * @param \StructType\Field $pdfFontEmbedded
     * @return \StructType\SO641010CommonSettings
     */
    public function setPdfFontEmbedded(\StructType\Field $pdfFontEmbedded = null)
    {
        $this->PdfFontEmbedded = $pdfFontEmbedded;
        return $this;
    }
    /**
     * Get AlternativeEngine value
     * @return \StructType\Field|null
     */
    public function getAlternativeEngine()
    {
        return $this->AlternativeEngine;
    }
    /**
     * Set AlternativeEngine value
     * @param \StructType\Field $alternativeEngine
     * @return \StructType\SO641010CommonSettings
     */
    public function setAlternativeEngine(\StructType\Field $alternativeEngine = null)
    {
        $this->AlternativeEngine = $alternativeEngine;
        return $this;
    }
    /**
     * Get PrintAllPages value
     * @return \StructType\Field|null
     */
    public function getPrintAllPages()
    {
        return $this->PrintAllPages;
    }
    /**
     * Set PrintAllPages value
     * @param \StructType\Field $printAllPages
     * @return \StructType\SO641010CommonSettings
     */
    public function setPrintAllPages(\StructType\Field $printAllPages = null)
    {
        $this->PrintAllPages = $printAllPages;
        return $this;
    }
    /**
     * Get DeletedRecords value
     * @return \StructType\Field|null
     */
    public function getDeletedRecords()
    {
        return $this->DeletedRecords;
    }
    /**
     * Set DeletedRecords value
     * @param \StructType\Field $deletedRecords
     * @return \StructType\SO641010CommonSettings
     */
    public function setDeletedRecords(\StructType\Field $deletedRecords = null)
    {
        $this->DeletedRecords = $deletedRecords;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SO641010CommonSettingsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SO641010CommonSettingsServiceCommands $serviceCommands
     * @return \StructType\SO641010CommonSettings
     */
    public function setServiceCommands(\StructType\SO641010CommonSettingsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO641010CommonSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
