<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElementDescriptor StructType
 * @subpackage Structs
 */
class ElementDescriptor extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The IsDisabled
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsDisabled;
    /**
     * The IsRequired
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsRequired;
    /**
     * The ElementType
     * Meta information extracted from the WSDL
     * - default: String
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ElementType;
    /**
     * The LengthLimit
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $LengthLimit;
    /**
     * The InputMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InputMask;
    /**
     * The DisplayRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayRules;
    /**
     * The AllowedValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AllowedValues;
    /**
     * Constructor method for ElementDescriptor
     * @uses ElementDescriptor::setDisplayName()
     * @uses ElementDescriptor::setIsDisabled()
     * @uses ElementDescriptor::setIsRequired()
     * @uses ElementDescriptor::setElementType()
     * @uses ElementDescriptor::setLengthLimit()
     * @uses ElementDescriptor::setInputMask()
     * @uses ElementDescriptor::setDisplayRules()
     * @uses ElementDescriptor::setAllowedValues()
     * @param string $displayName
     * @param bool $isDisabled
     * @param bool $isRequired
     * @param string $elementType
     * @param int $lengthLimit
     * @param string $inputMask
     * @param string $displayRules
     * @param \ArrayType\ArrayOfString $allowedValues
     */
    public function __construct($displayName = null, $isDisabled = false, $isRequired = false, $elementType = 'String', $lengthLimit = 0, $inputMask = null, $displayRules = null, \ArrayType\ArrayOfString $allowedValues = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setIsDisabled($isDisabled)
            ->setIsRequired($isRequired)
            ->setElementType($elementType)
            ->setLengthLimit($lengthLimit)
            ->setInputMask($inputMask)
            ->setDisplayRules($displayRules)
            ->setAllowedValues($allowedValues);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ElementDescriptor
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get IsDisabled value
     * @return bool|null
     */
    public function getIsDisabled()
    {
        return $this->IsDisabled;
    }
    /**
     * Set IsDisabled value
     * @param bool $isDisabled
     * @return \StructType\ElementDescriptor
     */
    public function setIsDisabled($isDisabled = false)
    {
        // validation for constraint: boolean
        if (!is_null($isDisabled) && !is_bool($isDisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDisabled, true), gettype($isDisabled)), __LINE__);
        }
        $this->IsDisabled = $isDisabled;
        return $this;
    }
    /**
     * Get IsRequired value
     * @return bool|null
     */
    public function getIsRequired()
    {
        return $this->IsRequired;
    }
    /**
     * Set IsRequired value
     * @param bool $isRequired
     * @return \StructType\ElementDescriptor
     */
    public function setIsRequired($isRequired = false)
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequired, true), gettype($isRequired)), __LINE__);
        }
        $this->IsRequired = $isRequired;
        return $this;
    }
    /**
     * Get ElementType value
     * @return string|null
     */
    public function getElementType()
    {
        return $this->ElementType;
    }
    /**
     * Set ElementType value
     * @uses \EnumType\ElementTypes::valueIsValid()
     * @uses \EnumType\ElementTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $elementType
     * @return \StructType\ElementDescriptor
     */
    public function setElementType($elementType = 'String')
    {
        // validation for constraint: enumeration
        if (!\EnumType\ElementTypes::valueIsValid($elementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ElementTypes', is_array($elementType) ? implode(', ', $elementType) : var_export($elementType, true), implode(', ', \EnumType\ElementTypes::getValidValues())), __LINE__);
        }
        $this->ElementType = $elementType;
        return $this;
    }
    /**
     * Get LengthLimit value
     * @return int|null
     */
    public function getLengthLimit()
    {
        return $this->LengthLimit;
    }
    /**
     * Set LengthLimit value
     * @param int $lengthLimit
     * @return \StructType\ElementDescriptor
     */
    public function setLengthLimit($lengthLimit = 0)
    {
        // validation for constraint: int
        if (!is_null($lengthLimit) && !(is_int($lengthLimit) || ctype_digit($lengthLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lengthLimit, true), gettype($lengthLimit)), __LINE__);
        }
        $this->LengthLimit = $lengthLimit;
        return $this;
    }
    /**
     * Get InputMask value
     * @return string|null
     */
    public function getInputMask()
    {
        return $this->InputMask;
    }
    /**
     * Set InputMask value
     * @param string $inputMask
     * @return \StructType\ElementDescriptor
     */
    public function setInputMask($inputMask = null)
    {
        // validation for constraint: string
        if (!is_null($inputMask) && !is_string($inputMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputMask, true), gettype($inputMask)), __LINE__);
        }
        $this->InputMask = $inputMask;
        return $this;
    }
    /**
     * Get DisplayRules value
     * @return string|null
     */
    public function getDisplayRules()
    {
        return $this->DisplayRules;
    }
    /**
     * Set DisplayRules value
     * @param string $displayRules
     * @return \StructType\ElementDescriptor
     */
    public function setDisplayRules($displayRules = null)
    {
        // validation for constraint: string
        if (!is_null($displayRules) && !is_string($displayRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayRules, true), gettype($displayRules)), __LINE__);
        }
        $this->DisplayRules = $displayRules;
        return $this;
    }
    /**
     * Get AllowedValues value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAllowedValues()
    {
        return $this->AllowedValues;
    }
    /**
     * Set AllowedValues value
     * @param \ArrayType\ArrayOfString $allowedValues
     * @return \StructType\ElementDescriptor
     */
    public function setAllowedValues(\ArrayType\ArrayOfString $allowedValues = null)
    {
        $this->AllowedValues = $allowedValues;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ElementDescriptor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
