<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SOS ServiceType
 * @subpackage Services
 */
class SOS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SO641010SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO641010SetSchema $parameters
     * @return \StructType\SO641010SetSchemaResponse|bool
     */
    public function SO641010SetSchema(\StructType\SO641010SetSchema $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SO641010SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO641010Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO641010Submit $parameters
     * @return \StructType\SO641010SubmitResponse|bool
     */
    public function SO641010Submit(\StructType\SO641010Submit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SO641010Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SO641010SetSchemaResponse|\StructType\SO641010SubmitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
