<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SOG ServiceType
 * @subpackage Services
 */
class SOG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SO641010GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO641010GetProcessStatus $parameters
     * @return \StructType\SO641010GetProcessStatusResponse|bool
     */
    public function SO641010GetProcessStatus(\StructType\SO641010GetProcessStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SO641010GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SO641010GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO641010GetSchema $parameters
     * @return \StructType\SO641010GetSchemaResponse|bool
     */
    public function SO641010GetSchema(\StructType\SO641010GetSchema $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SO641010GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SO641010GetProcessStatusResponse|\StructType\SO641010GetSchemaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
