<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SOE ServiceType
 * @subpackage Services
 */
class SOE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SO641010Export
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO641010Export $parameters
     * @return \StructType\SO641010ExportResponse|bool
     */
    public function SO641010Export(\StructType\SO641010Export $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SO641010Export($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SO641010ExportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
