<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SOC ServiceType
 * @subpackage Services
 */
class SOC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SO641010Clear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SO641010Clear $parameters
     * @return \StructType\SO641010ClearResponse|bool
     */
    public function SO641010Clear(\StructType\SO641010Clear $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SO641010Clear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SO641010ClearResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
