<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Clear ServiceType
 */
$clear = new \ServiceType\Clear($options);
/**
 * Sample call for Clear operation/method
 */
if ($clear->Clear(new \StructType\Clear()) !== false) {
    print_r($clear->getResult());
} else {
    print_r($clear->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetProcessStatus operation/method
 */
if ($get->GetProcessStatus(new \StructType\GetProcessStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetScenario operation/method
 */
if ($get->GetScenario(new \StructType\GetScenario()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSchema operation/method
 */
if ($get->GetSchema(new \StructType\GetSchema()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetSchema operation/method
 */
if ($set->SetSchema(new \StructType\SetSchema()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetBusinessDate operation/method
 */
if ($set->SetBusinessDate(new \StructType\SetBusinessDate()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetLocaleName operation/method
 */
if ($set->SetLocaleName(new \StructType\SetLocaleName()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSchemaMode operation/method
 */
if ($set->SetSchemaMode(new \StructType\SetSchemaMode()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Export ServiceType
 */
$export = new \ServiceType\Export($options);
/**
 * Sample call for Export operation/method
 */
if ($export->Export(new \StructType\Export()) !== false) {
    print_r($export->getResult());
} else {
    print_r($export->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
/**
 * Sample call for Import operation/method
 */
if ($import->Import(new \StructType\Import()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Submit ServiceType
 */
$submit = new \ServiceType\Submit($options);
/**
 * Sample call for Submit operation/method
 */
if ($submit->Submit(new \StructType\Submit()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login(new \StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for Logout operation/method
 */
if ($logout->Logout(new \StructType\Logout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
