<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSchema StructType
 * @subpackage Structs
 */
class SetSchema extends AbstractStructBase
{
    /**
     * The schema
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Content
     */
    public $schema;
    /**
     * Constructor method for SetSchema
     * @uses SetSchema::setSchema()
     * @param \StructType\Content $schema
     */
    public function __construct(\StructType\Content $schema = null)
    {
        $this
            ->setSchema($schema);
    }
    /**
     * Get schema value
     * @return \StructType\Content|null
     */
    public function getSchema()
    {
        return $this->schema;
    }
    /**
     * Set schema value
     * @param \StructType\Content $schema
     * @return \StructType\SetSchema
     */
    public function setSchema(\StructType\Content $schema = null)
    {
        $this->schema = $schema;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetSchema
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
