<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentSettings StructType
 * @subpackage Structs
 */
class PaymentSettings extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PaymentMethod;
    /**
     * The CardAccountNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CardAccountNo;
    /**
     * The CardAccountNoIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CardAccountNoIdentifier;
    /**
     * The CashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CashAccount;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PaymentRef;
    /**
     * The CCNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CCNumber;
    /**
     * The NewCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NewCard;
    /**
     * The ProcessingStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProcessingStatus;
    /**
     * The PCResponseReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PCResponseReason;
    /**
     * The PreAuthNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PreAuthNbr;
    /**
     * The AuthExpiresOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AuthExpiresOn;
    /**
     * The PreAuthorizedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PreAuthorizedAmount;
    /**
     * The PaymentTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PaymentTotal;
    /**
     * The UnpaidBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnpaidBalance;
    /**
     * The CaptureTranNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CaptureTranNbr;
    /**
     * The OrigPCRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrigPCRefNbr;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentSettingsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for PaymentSettings
     * @uses PaymentSettings::setDisplayName()
     * @uses PaymentSettings::setPaymentMethod()
     * @uses PaymentSettings::setCardAccountNo()
     * @uses PaymentSettings::setCardAccountNoIdentifier()
     * @uses PaymentSettings::setCashAccount()
     * @uses PaymentSettings::setPaymentRef()
     * @uses PaymentSettings::setCCNumber()
     * @uses PaymentSettings::setNewCard()
     * @uses PaymentSettings::setProcessingStatus()
     * @uses PaymentSettings::setPCResponseReason()
     * @uses PaymentSettings::setPreAuthNbr()
     * @uses PaymentSettings::setAuthExpiresOn()
     * @uses PaymentSettings::setPreAuthorizedAmount()
     * @uses PaymentSettings::setPaymentTotal()
     * @uses PaymentSettings::setUnpaidBalance()
     * @uses PaymentSettings::setCaptureTranNbr()
     * @uses PaymentSettings::setOrigPCRefNbr()
     * @uses PaymentSettings::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $paymentMethod
     * @param \StructType\Field $cardAccountNo
     * @param \StructType\Field $cardAccountNoIdentifier
     * @param \StructType\Field $cashAccount
     * @param \StructType\Field $paymentRef
     * @param \StructType\Field $cCNumber
     * @param \StructType\Field $newCard
     * @param \StructType\Field $processingStatus
     * @param \StructType\Field $pCResponseReason
     * @param \StructType\Field $preAuthNbr
     * @param \StructType\Field $authExpiresOn
     * @param \StructType\Field $preAuthorizedAmount
     * @param \StructType\Field $paymentTotal
     * @param \StructType\Field $unpaidBalance
     * @param \StructType\Field $captureTranNbr
     * @param \StructType\Field $origPCRefNbr
     * @param \StructType\PaymentSettingsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $paymentMethod = null, \StructType\Field $cardAccountNo = null, \StructType\Field $cardAccountNoIdentifier = null, \StructType\Field $cashAccount = null, \StructType\Field $paymentRef = null, \StructType\Field $cCNumber = null, \StructType\Field $newCard = null, \StructType\Field $processingStatus = null, \StructType\Field $pCResponseReason = null, \StructType\Field $preAuthNbr = null, \StructType\Field $authExpiresOn = null, \StructType\Field $preAuthorizedAmount = null, \StructType\Field $paymentTotal = null, \StructType\Field $unpaidBalance = null, \StructType\Field $captureTranNbr = null, \StructType\Field $origPCRefNbr = null, \StructType\PaymentSettingsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setPaymentMethod($paymentMethod)
            ->setCardAccountNo($cardAccountNo)
            ->setCardAccountNoIdentifier($cardAccountNoIdentifier)
            ->setCashAccount($cashAccount)
            ->setPaymentRef($paymentRef)
            ->setCCNumber($cCNumber)
            ->setNewCard($newCard)
            ->setProcessingStatus($processingStatus)
            ->setPCResponseReason($pCResponseReason)
            ->setPreAuthNbr($preAuthNbr)
            ->setAuthExpiresOn($authExpiresOn)
            ->setPreAuthorizedAmount($preAuthorizedAmount)
            ->setPaymentTotal($paymentTotal)
            ->setUnpaidBalance($unpaidBalance)
            ->setCaptureTranNbr($captureTranNbr)
            ->setOrigPCRefNbr($origPCRefNbr)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\PaymentSettings
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return \StructType\Field|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param \StructType\Field $paymentMethod
     * @return \StructType\PaymentSettings
     */
    public function setPaymentMethod(\StructType\Field $paymentMethod = null)
    {
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get CardAccountNo value
     * @return \StructType\Field|null
     */
    public function getCardAccountNo()
    {
        return $this->CardAccountNo;
    }
    /**
     * Set CardAccountNo value
     * @param \StructType\Field $cardAccountNo
     * @return \StructType\PaymentSettings
     */
    public function setCardAccountNo(\StructType\Field $cardAccountNo = null)
    {
        $this->CardAccountNo = $cardAccountNo;
        return $this;
    }
    /**
     * Get CardAccountNoIdentifier value
     * @return \StructType\Field|null
     */
    public function getCardAccountNoIdentifier()
    {
        return $this->CardAccountNoIdentifier;
    }
    /**
     * Set CardAccountNoIdentifier value
     * @param \StructType\Field $cardAccountNoIdentifier
     * @return \StructType\PaymentSettings
     */
    public function setCardAccountNoIdentifier(\StructType\Field $cardAccountNoIdentifier = null)
    {
        $this->CardAccountNoIdentifier = $cardAccountNoIdentifier;
        return $this;
    }
    /**
     * Get CashAccount value
     * @return \StructType\Field|null
     */
    public function getCashAccount()
    {
        return $this->CashAccount;
    }
    /**
     * Set CashAccount value
     * @param \StructType\Field $cashAccount
     * @return \StructType\PaymentSettings
     */
    public function setCashAccount(\StructType\Field $cashAccount = null)
    {
        $this->CashAccount = $cashAccount;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return \StructType\Field|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param \StructType\Field $paymentRef
     * @return \StructType\PaymentSettings
     */
    public function setPaymentRef(\StructType\Field $paymentRef = null)
    {
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get CCNumber value
     * @return \StructType\Field|null
     */
    public function getCCNumber()
    {
        return $this->CCNumber;
    }
    /**
     * Set CCNumber value
     * @param \StructType\Field $cCNumber
     * @return \StructType\PaymentSettings
     */
    public function setCCNumber(\StructType\Field $cCNumber = null)
    {
        $this->CCNumber = $cCNumber;
        return $this;
    }
    /**
     * Get NewCard value
     * @return \StructType\Field|null
     */
    public function getNewCard()
    {
        return $this->NewCard;
    }
    /**
     * Set NewCard value
     * @param \StructType\Field $newCard
     * @return \StructType\PaymentSettings
     */
    public function setNewCard(\StructType\Field $newCard = null)
    {
        $this->NewCard = $newCard;
        return $this;
    }
    /**
     * Get ProcessingStatus value
     * @return \StructType\Field|null
     */
    public function getProcessingStatus()
    {
        return $this->ProcessingStatus;
    }
    /**
     * Set ProcessingStatus value
     * @param \StructType\Field $processingStatus
     * @return \StructType\PaymentSettings
     */
    public function setProcessingStatus(\StructType\Field $processingStatus = null)
    {
        $this->ProcessingStatus = $processingStatus;
        return $this;
    }
    /**
     * Get PCResponseReason value
     * @return \StructType\Field|null
     */
    public function getPCResponseReason()
    {
        return $this->PCResponseReason;
    }
    /**
     * Set PCResponseReason value
     * @param \StructType\Field $pCResponseReason
     * @return \StructType\PaymentSettings
     */
    public function setPCResponseReason(\StructType\Field $pCResponseReason = null)
    {
        $this->PCResponseReason = $pCResponseReason;
        return $this;
    }
    /**
     * Get PreAuthNbr value
     * @return \StructType\Field|null
     */
    public function getPreAuthNbr()
    {
        return $this->PreAuthNbr;
    }
    /**
     * Set PreAuthNbr value
     * @param \StructType\Field $preAuthNbr
     * @return \StructType\PaymentSettings
     */
    public function setPreAuthNbr(\StructType\Field $preAuthNbr = null)
    {
        $this->PreAuthNbr = $preAuthNbr;
        return $this;
    }
    /**
     * Get AuthExpiresOn value
     * @return \StructType\Field|null
     */
    public function getAuthExpiresOn()
    {
        return $this->AuthExpiresOn;
    }
    /**
     * Set AuthExpiresOn value
     * @param \StructType\Field $authExpiresOn
     * @return \StructType\PaymentSettings
     */
    public function setAuthExpiresOn(\StructType\Field $authExpiresOn = null)
    {
        $this->AuthExpiresOn = $authExpiresOn;
        return $this;
    }
    /**
     * Get PreAuthorizedAmount value
     * @return \StructType\Field|null
     */
    public function getPreAuthorizedAmount()
    {
        return $this->PreAuthorizedAmount;
    }
    /**
     * Set PreAuthorizedAmount value
     * @param \StructType\Field $preAuthorizedAmount
     * @return \StructType\PaymentSettings
     */
    public function setPreAuthorizedAmount(\StructType\Field $preAuthorizedAmount = null)
    {
        $this->PreAuthorizedAmount = $preAuthorizedAmount;
        return $this;
    }
    /**
     * Get PaymentTotal value
     * @return \StructType\Field|null
     */
    public function getPaymentTotal()
    {
        return $this->PaymentTotal;
    }
    /**
     * Set PaymentTotal value
     * @param \StructType\Field $paymentTotal
     * @return \StructType\PaymentSettings
     */
    public function setPaymentTotal(\StructType\Field $paymentTotal = null)
    {
        $this->PaymentTotal = $paymentTotal;
        return $this;
    }
    /**
     * Get UnpaidBalance value
     * @return \StructType\Field|null
     */
    public function getUnpaidBalance()
    {
        return $this->UnpaidBalance;
    }
    /**
     * Set UnpaidBalance value
     * @param \StructType\Field $unpaidBalance
     * @return \StructType\PaymentSettings
     */
    public function setUnpaidBalance(\StructType\Field $unpaidBalance = null)
    {
        $this->UnpaidBalance = $unpaidBalance;
        return $this;
    }
    /**
     * Get CaptureTranNbr value
     * @return \StructType\Field|null
     */
    public function getCaptureTranNbr()
    {
        return $this->CaptureTranNbr;
    }
    /**
     * Set CaptureTranNbr value
     * @param \StructType\Field $captureTranNbr
     * @return \StructType\PaymentSettings
     */
    public function setCaptureTranNbr(\StructType\Field $captureTranNbr = null)
    {
        $this->CaptureTranNbr = $captureTranNbr;
        return $this;
    }
    /**
     * Get OrigPCRefNbr value
     * @return \StructType\Field|null
     */
    public function getOrigPCRefNbr()
    {
        return $this->OrigPCRefNbr;
    }
    /**
     * Set OrigPCRefNbr value
     * @param \StructType\Field $origPCRefNbr
     * @return \StructType\PaymentSettings
     */
    public function setOrigPCRefNbr(\StructType\Field $origPCRefNbr = null)
    {
        $this->OrigPCRefNbr = $origPCRefNbr;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\PaymentSettingsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\PaymentSettingsServiceCommands $serviceCommands
     * @return \StructType\PaymentSettings
     */
    public function setServiceCommands(\StructType\PaymentSettingsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
