<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderSummary StructType
 * @subpackage Structs
 */
class OrderSummary extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNbr;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Hold;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Status;
    /**
     * The DonTApprove
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DonTApprove;
    /**
     * The Approved
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Approved;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Date;
    /**
     * The RequestedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RequestedOn;
    /**
     * The CustomerOrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CustomerOrderNbr;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExternalReference;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Customer;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Location;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Currency;
    /**
     * The CuryViewState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CuryViewState;
    /**
     * The DestinationWarehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DestinationWarehouse;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Project;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Description;
    /**
     * The OrderedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderedQty;
    /**
     * The DiscountTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountTotal;
    /**
     * The VATExemptTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VATExemptTotal;
    /**
     * The VATTaxableTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VATTaxableTotal;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxTotal;
    /**
     * The OrderTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderTotal;
    /**
     * The ControlTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ControlTotal;
    /**
     * The ROTAndRUTDeductibleDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ROTAndRUTDeductibleDocument;
    /**
     * The IsFSIntegrated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $IsFSIntegrated;
    /**
     * The NoteText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderSummaryServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for OrderSummary
     * @uses OrderSummary::setDisplayName()
     * @uses OrderSummary::setOrderType()
     * @uses OrderSummary::setOrderNbr()
     * @uses OrderSummary::setHold()
     * @uses OrderSummary::setStatus()
     * @uses OrderSummary::setDonTApprove()
     * @uses OrderSummary::setApproved()
     * @uses OrderSummary::setDate()
     * @uses OrderSummary::setRequestedOn()
     * @uses OrderSummary::setCustomerOrderNbr()
     * @uses OrderSummary::setExternalReference()
     * @uses OrderSummary::setCustomer()
     * @uses OrderSummary::setLocation()
     * @uses OrderSummary::setCurrency()
     * @uses OrderSummary::setCuryViewState()
     * @uses OrderSummary::setDestinationWarehouse()
     * @uses OrderSummary::setProject()
     * @uses OrderSummary::setDescription()
     * @uses OrderSummary::setOrderedQty()
     * @uses OrderSummary::setDiscountTotal()
     * @uses OrderSummary::setVATExemptTotal()
     * @uses OrderSummary::setVATTaxableTotal()
     * @uses OrderSummary::setTaxTotal()
     * @uses OrderSummary::setOrderTotal()
     * @uses OrderSummary::setControlTotal()
     * @uses OrderSummary::setROTAndRUTDeductibleDocument()
     * @uses OrderSummary::setIsFSIntegrated()
     * @uses OrderSummary::setNoteText()
     * @uses OrderSummary::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNbr
     * @param \StructType\Field $hold
     * @param \StructType\Field $status
     * @param \StructType\Field $donTApprove
     * @param \StructType\Field $approved
     * @param \StructType\Field $date
     * @param \StructType\Field $requestedOn
     * @param \StructType\Field $customerOrderNbr
     * @param \StructType\Field $externalReference
     * @param \StructType\Field $customer
     * @param \StructType\Field $location
     * @param \StructType\Field $currency
     * @param \StructType\Field $curyViewState
     * @param \StructType\Field $destinationWarehouse
     * @param \StructType\Field $project
     * @param \StructType\Field $description
     * @param \StructType\Field $orderedQty
     * @param \StructType\Field $discountTotal
     * @param \StructType\Field $vATExemptTotal
     * @param \StructType\Field $vATTaxableTotal
     * @param \StructType\Field $taxTotal
     * @param \StructType\Field $orderTotal
     * @param \StructType\Field $controlTotal
     * @param \StructType\Field $rOTAndRUTDeductibleDocument
     * @param \StructType\Field $isFSIntegrated
     * @param \StructType\Field $noteText
     * @param \StructType\OrderSummaryServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $orderType = null, \StructType\Field $orderNbr = null, \StructType\Field $hold = null, \StructType\Field $status = null, \StructType\Field $donTApprove = null, \StructType\Field $approved = null, \StructType\Field $date = null, \StructType\Field $requestedOn = null, \StructType\Field $customerOrderNbr = null, \StructType\Field $externalReference = null, \StructType\Field $customer = null, \StructType\Field $location = null, \StructType\Field $currency = null, \StructType\Field $curyViewState = null, \StructType\Field $destinationWarehouse = null, \StructType\Field $project = null, \StructType\Field $description = null, \StructType\Field $orderedQty = null, \StructType\Field $discountTotal = null, \StructType\Field $vATExemptTotal = null, \StructType\Field $vATTaxableTotal = null, \StructType\Field $taxTotal = null, \StructType\Field $orderTotal = null, \StructType\Field $controlTotal = null, \StructType\Field $rOTAndRUTDeductibleDocument = null, \StructType\Field $isFSIntegrated = null, \StructType\Field $noteText = null, \StructType\OrderSummaryServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setOrderType($orderType)
            ->setOrderNbr($orderNbr)
            ->setHold($hold)
            ->setStatus($status)
            ->setDonTApprove($donTApprove)
            ->setApproved($approved)
            ->setDate($date)
            ->setRequestedOn($requestedOn)
            ->setCustomerOrderNbr($customerOrderNbr)
            ->setExternalReference($externalReference)
            ->setCustomer($customer)
            ->setLocation($location)
            ->setCurrency($currency)
            ->setCuryViewState($curyViewState)
            ->setDestinationWarehouse($destinationWarehouse)
            ->setProject($project)
            ->setDescription($description)
            ->setOrderedQty($orderedQty)
            ->setDiscountTotal($discountTotal)
            ->setVATExemptTotal($vATExemptTotal)
            ->setVATTaxableTotal($vATTaxableTotal)
            ->setTaxTotal($taxTotal)
            ->setOrderTotal($orderTotal)
            ->setControlTotal($controlTotal)
            ->setROTAndRUTDeductibleDocument($rOTAndRUTDeductibleDocument)
            ->setIsFSIntegrated($isFSIntegrated)
            ->setNoteText($noteText)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\OrderSummary
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\OrderSummary
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNbr value
     * @return \StructType\Field|null
     */
    public function getOrderNbr()
    {
        return $this->OrderNbr;
    }
    /**
     * Set OrderNbr value
     * @param \StructType\Field $orderNbr
     * @return \StructType\OrderSummary
     */
    public function setOrderNbr(\StructType\Field $orderNbr = null)
    {
        $this->OrderNbr = $orderNbr;
        return $this;
    }
    /**
     * Get Hold value
     * @return \StructType\Field|null
     */
    public function getHold()
    {
        return $this->Hold;
    }
    /**
     * Set Hold value
     * @param \StructType\Field $hold
     * @return \StructType\OrderSummary
     */
    public function setHold(\StructType\Field $hold = null)
    {
        $this->Hold = $hold;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Field|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Field $status
     * @return \StructType\OrderSummary
     */
    public function setStatus(\StructType\Field $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DonTApprove value
     * @return \StructType\Field|null
     */
    public function getDonTApprove()
    {
        return $this->DonTApprove;
    }
    /**
     * Set DonTApprove value
     * @param \StructType\Field $donTApprove
     * @return \StructType\OrderSummary
     */
    public function setDonTApprove(\StructType\Field $donTApprove = null)
    {
        $this->DonTApprove = $donTApprove;
        return $this;
    }
    /**
     * Get Approved value
     * @return \StructType\Field|null
     */
    public function getApproved()
    {
        return $this->Approved;
    }
    /**
     * Set Approved value
     * @param \StructType\Field $approved
     * @return \StructType\OrderSummary
     */
    public function setApproved(\StructType\Field $approved = null)
    {
        $this->Approved = $approved;
        return $this;
    }
    /**
     * Get Date value
     * @return \StructType\Field|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param \StructType\Field $date
     * @return \StructType\OrderSummary
     */
    public function setDate(\StructType\Field $date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Get RequestedOn value
     * @return \StructType\Field|null
     */
    public function getRequestedOn()
    {
        return $this->RequestedOn;
    }
    /**
     * Set RequestedOn value
     * @param \StructType\Field $requestedOn
     * @return \StructType\OrderSummary
     */
    public function setRequestedOn(\StructType\Field $requestedOn = null)
    {
        $this->RequestedOn = $requestedOn;
        return $this;
    }
    /**
     * Get CustomerOrderNbr value
     * @return \StructType\Field|null
     */
    public function getCustomerOrderNbr()
    {
        return $this->CustomerOrderNbr;
    }
    /**
     * Set CustomerOrderNbr value
     * @param \StructType\Field $customerOrderNbr
     * @return \StructType\OrderSummary
     */
    public function setCustomerOrderNbr(\StructType\Field $customerOrderNbr = null)
    {
        $this->CustomerOrderNbr = $customerOrderNbr;
        return $this;
    }
    /**
     * Get ExternalReference value
     * @return \StructType\Field|null
     */
    public function getExternalReference()
    {
        return $this->ExternalReference;
    }
    /**
     * Set ExternalReference value
     * @param \StructType\Field $externalReference
     * @return \StructType\OrderSummary
     */
    public function setExternalReference(\StructType\Field $externalReference = null)
    {
        $this->ExternalReference = $externalReference;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\Field|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\Field $customer
     * @return \StructType\OrderSummary
     */
    public function setCustomer(\StructType\Field $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Field|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Field $location
     * @return \StructType\OrderSummary
     */
    public function setLocation(\StructType\Field $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Currency value
     * @return \StructType\Field|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param \StructType\Field $currency
     * @return \StructType\OrderSummary
     */
    public function setCurrency(\StructType\Field $currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get CuryViewState value
     * @return \StructType\Field|null
     */
    public function getCuryViewState()
    {
        return $this->CuryViewState;
    }
    /**
     * Set CuryViewState value
     * @param \StructType\Field $curyViewState
     * @return \StructType\OrderSummary
     */
    public function setCuryViewState(\StructType\Field $curyViewState = null)
    {
        $this->CuryViewState = $curyViewState;
        return $this;
    }
    /**
     * Get DestinationWarehouse value
     * @return \StructType\Field|null
     */
    public function getDestinationWarehouse()
    {
        return $this->DestinationWarehouse;
    }
    /**
     * Set DestinationWarehouse value
     * @param \StructType\Field $destinationWarehouse
     * @return \StructType\OrderSummary
     */
    public function setDestinationWarehouse(\StructType\Field $destinationWarehouse = null)
    {
        $this->DestinationWarehouse = $destinationWarehouse;
        return $this;
    }
    /**
     * Get Project value
     * @return \StructType\Field|null
     */
    public function getProject()
    {
        return $this->Project;
    }
    /**
     * Set Project value
     * @param \StructType\Field $project
     * @return \StructType\OrderSummary
     */
    public function setProject(\StructType\Field $project = null)
    {
        $this->Project = $project;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Field|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Field $description
     * @return \StructType\OrderSummary
     */
    public function setDescription(\StructType\Field $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get OrderedQty value
     * @return \StructType\Field|null
     */
    public function getOrderedQty()
    {
        return $this->OrderedQty;
    }
    /**
     * Set OrderedQty value
     * @param \StructType\Field $orderedQty
     * @return \StructType\OrderSummary
     */
    public function setOrderedQty(\StructType\Field $orderedQty = null)
    {
        $this->OrderedQty = $orderedQty;
        return $this;
    }
    /**
     * Get DiscountTotal value
     * @return \StructType\Field|null
     */
    public function getDiscountTotal()
    {
        return $this->DiscountTotal;
    }
    /**
     * Set DiscountTotal value
     * @param \StructType\Field $discountTotal
     * @return \StructType\OrderSummary
     */
    public function setDiscountTotal(\StructType\Field $discountTotal = null)
    {
        $this->DiscountTotal = $discountTotal;
        return $this;
    }
    /**
     * Get VATExemptTotal value
     * @return \StructType\Field|null
     */
    public function getVATExemptTotal()
    {
        return $this->VATExemptTotal;
    }
    /**
     * Set VATExemptTotal value
     * @param \StructType\Field $vATExemptTotal
     * @return \StructType\OrderSummary
     */
    public function setVATExemptTotal(\StructType\Field $vATExemptTotal = null)
    {
        $this->VATExemptTotal = $vATExemptTotal;
        return $this;
    }
    /**
     * Get VATTaxableTotal value
     * @return \StructType\Field|null
     */
    public function getVATTaxableTotal()
    {
        return $this->VATTaxableTotal;
    }
    /**
     * Set VATTaxableTotal value
     * @param \StructType\Field $vATTaxableTotal
     * @return \StructType\OrderSummary
     */
    public function setVATTaxableTotal(\StructType\Field $vATTaxableTotal = null)
    {
        $this->VATTaxableTotal = $vATTaxableTotal;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \StructType\Field|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param \StructType\Field $taxTotal
     * @return \StructType\OrderSummary
     */
    public function setTaxTotal(\StructType\Field $taxTotal = null)
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get OrderTotal value
     * @return \StructType\Field|null
     */
    public function getOrderTotal()
    {
        return $this->OrderTotal;
    }
    /**
     * Set OrderTotal value
     * @param \StructType\Field $orderTotal
     * @return \StructType\OrderSummary
     */
    public function setOrderTotal(\StructType\Field $orderTotal = null)
    {
        $this->OrderTotal = $orderTotal;
        return $this;
    }
    /**
     * Get ControlTotal value
     * @return \StructType\Field|null
     */
    public function getControlTotal()
    {
        return $this->ControlTotal;
    }
    /**
     * Set ControlTotal value
     * @param \StructType\Field $controlTotal
     * @return \StructType\OrderSummary
     */
    public function setControlTotal(\StructType\Field $controlTotal = null)
    {
        $this->ControlTotal = $controlTotal;
        return $this;
    }
    /**
     * Get ROTAndRUTDeductibleDocument value
     * @return \StructType\Field|null
     */
    public function getROTAndRUTDeductibleDocument()
    {
        return $this->ROTAndRUTDeductibleDocument;
    }
    /**
     * Set ROTAndRUTDeductibleDocument value
     * @param \StructType\Field $rOTAndRUTDeductibleDocument
     * @return \StructType\OrderSummary
     */
    public function setROTAndRUTDeductibleDocument(\StructType\Field $rOTAndRUTDeductibleDocument = null)
    {
        $this->ROTAndRUTDeductibleDocument = $rOTAndRUTDeductibleDocument;
        return $this;
    }
    /**
     * Get IsFSIntegrated value
     * @return \StructType\Field|null
     */
    public function getIsFSIntegrated()
    {
        return $this->IsFSIntegrated;
    }
    /**
     * Set IsFSIntegrated value
     * @param \StructType\Field $isFSIntegrated
     * @return \StructType\OrderSummary
     */
    public function setIsFSIntegrated(\StructType\Field $isFSIntegrated = null)
    {
        $this->IsFSIntegrated = $isFSIntegrated;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\OrderSummary
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\OrderSummaryServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\OrderSummaryServiceCommands $serviceCommands
     * @return \StructType\OrderSummary
     */
    public function setServiceCommands(\StructType\OrderSummaryServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
