<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginResult StructType
 * @subpackage Structs
 */
class LoginResult extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Code;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Session
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Session;
    /**
     * Constructor method for LoginResult
     * @uses LoginResult::setCode()
     * @uses LoginResult::setMessage()
     * @uses LoginResult::setSession()
     * @param string $code
     * @param string $message
     * @param string $session
     */
    public function __construct($code = null, $message = null, $session = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message)
            ->setSession($session);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @uses \EnumType\ErrorCode::valueIsValid()
     * @uses \EnumType\ErrorCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\LoginResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ErrorCode::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ErrorCode', is_array($code) ? implode(', ', $code) : var_export($code, true), implode(', ', \EnumType\ErrorCode::getValidValues())), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\LoginResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Session value
     * @return string|null
     */
    public function getSession()
    {
        return $this->Session;
    }
    /**
     * Set Session value
     * @param string $session
     * @return \StructType\LoginResult
     */
    public function setSession($session = null)
    {
        // validation for constraint: string
        if (!is_null($session) && !is_string($session)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($session, true), gettype($session)), __LINE__);
        }
        $this->Session = $session;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoginResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
