<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Import StructType
 * @subpackage Structs
 */
class Import extends AbstractStructBase
{
    /**
     * The includedHeaders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includedHeaders;
    /**
     * The breakOnError
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $breakOnError;
    /**
     * The breakOnIncorrectTarget
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $breakOnIncorrectTarget;
    /**
     * The commands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommand
     */
    public $commands;
    /**
     * The filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFilter
     */
    public $filters;
    /**
     * The data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfArrayOfString
     */
    public $data;
    /**
     * Constructor method for Import
     * @uses Import::setIncludedHeaders()
     * @uses Import::setBreakOnError()
     * @uses Import::setBreakOnIncorrectTarget()
     * @uses Import::setCommands()
     * @uses Import::setFilters()
     * @uses Import::setData()
     * @param bool $includedHeaders
     * @param bool $breakOnError
     * @param bool $breakOnIncorrectTarget
     * @param \ArrayType\ArrayOfCommand $commands
     * @param \ArrayType\ArrayOfFilter $filters
     * @param \ArrayType\ArrayOfArrayOfString $data
     */
    public function __construct($includedHeaders = null, $breakOnError = null, $breakOnIncorrectTarget = null, \ArrayType\ArrayOfCommand $commands = null, \ArrayType\ArrayOfFilter $filters = null, \ArrayType\ArrayOfArrayOfString $data = null)
    {
        $this
            ->setIncludedHeaders($includedHeaders)
            ->setBreakOnError($breakOnError)
            ->setBreakOnIncorrectTarget($breakOnIncorrectTarget)
            ->setCommands($commands)
            ->setFilters($filters)
            ->setData($data);
    }
    /**
     * Get includedHeaders value
     * @return bool
     */
    public function getIncludedHeaders()
    {
        return $this->includedHeaders;
    }
    /**
     * Set includedHeaders value
     * @param bool $includedHeaders
     * @return \StructType\Import
     */
    public function setIncludedHeaders($includedHeaders = null)
    {
        // validation for constraint: boolean
        if (!is_null($includedHeaders) && !is_bool($includedHeaders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includedHeaders, true), gettype($includedHeaders)), __LINE__);
        }
        $this->includedHeaders = $includedHeaders;
        return $this;
    }
    /**
     * Get breakOnError value
     * @return bool
     */
    public function getBreakOnError()
    {
        return $this->breakOnError;
    }
    /**
     * Set breakOnError value
     * @param bool $breakOnError
     * @return \StructType\Import
     */
    public function setBreakOnError($breakOnError = null)
    {
        // validation for constraint: boolean
        if (!is_null($breakOnError) && !is_bool($breakOnError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($breakOnError, true), gettype($breakOnError)), __LINE__);
        }
        $this->breakOnError = $breakOnError;
        return $this;
    }
    /**
     * Get breakOnIncorrectTarget value
     * @return bool
     */
    public function getBreakOnIncorrectTarget()
    {
        return $this->breakOnIncorrectTarget;
    }
    /**
     * Set breakOnIncorrectTarget value
     * @param bool $breakOnIncorrectTarget
     * @return \StructType\Import
     */
    public function setBreakOnIncorrectTarget($breakOnIncorrectTarget = null)
    {
        // validation for constraint: boolean
        if (!is_null($breakOnIncorrectTarget) && !is_bool($breakOnIncorrectTarget)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($breakOnIncorrectTarget, true), gettype($breakOnIncorrectTarget)), __LINE__);
        }
        $this->breakOnIncorrectTarget = $breakOnIncorrectTarget;
        return $this;
    }
    /**
     * Get commands value
     * @return \ArrayType\ArrayOfCommand|null
     */
    public function getCommands()
    {
        return $this->commands;
    }
    /**
     * Set commands value
     * @param \ArrayType\ArrayOfCommand $commands
     * @return \StructType\Import
     */
    public function setCommands(\ArrayType\ArrayOfCommand $commands = null)
    {
        $this->commands = $commands;
        return $this;
    }
    /**
     * Get filters value
     * @return \ArrayType\ArrayOfFilter|null
     */
    public function getFilters()
    {
        return $this->filters;
    }
    /**
     * Set filters value
     * @param \ArrayType\ArrayOfFilter $filters
     * @return \StructType\Import
     */
    public function setFilters(\ArrayType\ArrayOfFilter $filters = null)
    {
        $this->filters = $filters;
        return $this;
    }
    /**
     * Get data value
     * @return \ArrayType\ArrayOfArrayOfString|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \ArrayType\ArrayOfArrayOfString $data
     * @return \StructType\Import
     */
    public function setData(\ArrayType\ArrayOfArrayOfString $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Import
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
