<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CopyTo StructType
 * @subpackage Structs
 */
class CopyTo extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNbr;
    /**
     * The RecalcUnitPrices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RecalcUnitPrices;
    /**
     * The OverrideManualPrices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OverrideManualPrices;
    /**
     * The RecalcDiscounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RecalcDiscounts;
    /**
     * The OverrideManualDiscounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OverrideManualDiscounts;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CopyToServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for CopyTo
     * @uses CopyTo::setDisplayName()
     * @uses CopyTo::setOrderType()
     * @uses CopyTo::setOrderNbr()
     * @uses CopyTo::setRecalcUnitPrices()
     * @uses CopyTo::setOverrideManualPrices()
     * @uses CopyTo::setRecalcDiscounts()
     * @uses CopyTo::setOverrideManualDiscounts()
     * @uses CopyTo::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNbr
     * @param \StructType\Field $recalcUnitPrices
     * @param \StructType\Field $overrideManualPrices
     * @param \StructType\Field $recalcDiscounts
     * @param \StructType\Field $overrideManualDiscounts
     * @param \StructType\CopyToServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $orderType = null, \StructType\Field $orderNbr = null, \StructType\Field $recalcUnitPrices = null, \StructType\Field $overrideManualPrices = null, \StructType\Field $recalcDiscounts = null, \StructType\Field $overrideManualDiscounts = null, \StructType\CopyToServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setOrderType($orderType)
            ->setOrderNbr($orderNbr)
            ->setRecalcUnitPrices($recalcUnitPrices)
            ->setOverrideManualPrices($overrideManualPrices)
            ->setRecalcDiscounts($recalcDiscounts)
            ->setOverrideManualDiscounts($overrideManualDiscounts)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\CopyTo
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\CopyTo
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNbr value
     * @return \StructType\Field|null
     */
    public function getOrderNbr()
    {
        return $this->OrderNbr;
    }
    /**
     * Set OrderNbr value
     * @param \StructType\Field $orderNbr
     * @return \StructType\CopyTo
     */
    public function setOrderNbr(\StructType\Field $orderNbr = null)
    {
        $this->OrderNbr = $orderNbr;
        return $this;
    }
    /**
     * Get RecalcUnitPrices value
     * @return \StructType\Field|null
     */
    public function getRecalcUnitPrices()
    {
        return $this->RecalcUnitPrices;
    }
    /**
     * Set RecalcUnitPrices value
     * @param \StructType\Field $recalcUnitPrices
     * @return \StructType\CopyTo
     */
    public function setRecalcUnitPrices(\StructType\Field $recalcUnitPrices = null)
    {
        $this->RecalcUnitPrices = $recalcUnitPrices;
        return $this;
    }
    /**
     * Get OverrideManualPrices value
     * @return \StructType\Field|null
     */
    public function getOverrideManualPrices()
    {
        return $this->OverrideManualPrices;
    }
    /**
     * Set OverrideManualPrices value
     * @param \StructType\Field $overrideManualPrices
     * @return \StructType\CopyTo
     */
    public function setOverrideManualPrices(\StructType\Field $overrideManualPrices = null)
    {
        $this->OverrideManualPrices = $overrideManualPrices;
        return $this;
    }
    /**
     * Get RecalcDiscounts value
     * @return \StructType\Field|null
     */
    public function getRecalcDiscounts()
    {
        return $this->RecalcDiscounts;
    }
    /**
     * Set RecalcDiscounts value
     * @param \StructType\Field $recalcDiscounts
     * @return \StructType\CopyTo
     */
    public function setRecalcDiscounts(\StructType\Field $recalcDiscounts = null)
    {
        $this->RecalcDiscounts = $recalcDiscounts;
        return $this;
    }
    /**
     * Get OverrideManualDiscounts value
     * @return \StructType\Field|null
     */
    public function getOverrideManualDiscounts()
    {
        return $this->OverrideManualDiscounts;
    }
    /**
     * Set OverrideManualDiscounts value
     * @param \StructType\Field $overrideManualDiscounts
     * @return \StructType\CopyTo
     */
    public function setOverrideManualDiscounts(\StructType\Field $overrideManualDiscounts = null)
    {
        $this->OverrideManualDiscounts = $overrideManualDiscounts;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\CopyToServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\CopyToServiceCommands $serviceCommands
     * @return \StructType\CopyTo
     */
    public function setServiceCommands(\StructType\CopyToServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CopyTo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
