<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfImportResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfImportResult extends AbstractStructArrayBase
{
    /**
     * The ImportResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ImportResult[]
     */
    public $ImportResult;
    /**
     * Constructor method for ArrayOfImportResult
     * @uses ArrayOfImportResult::setImportResult()
     * @param \StructType\ImportResult[] $importResult
     */
    public function __construct(array $importResult = array())
    {
        $this
            ->setImportResult($importResult);
    }
    /**
     * Get ImportResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ImportResult[]|null
     */
    public function getImportResult()
    {
        return isset($this->ImportResult) ? $this->ImportResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setImportResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImportResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImportResultForArrayConstraintsFromSetImportResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfImportResultImportResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfImportResultImportResultItem instanceof \StructType\ImportResult) {
                $invalidValues[] = is_object($arrayOfImportResultImportResultItem) ? get_class($arrayOfImportResultImportResultItem) : sprintf('%s(%s)', gettype($arrayOfImportResultImportResultItem), var_export($arrayOfImportResultImportResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImportResult property can only contain items of type \StructType\ImportResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImportResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ImportResult[] $importResult
     * @return \ArrayType\ArrayOfImportResult
     */
    public function setImportResult(array $importResult = array())
    {
        // validation for constraint: array
        if ('' !== ($importResultArrayErrorMessage = self::validateImportResultForArrayConstraintsFromSetImportResult($importResult))) {
            throw new \InvalidArgumentException($importResultArrayErrorMessage, __LINE__);
        }
        if (is_null($importResult) || (is_array($importResult) && empty($importResult))) {
            unset($this->ImportResult);
        } else {
            $this->ImportResult = $importResult;
        }
        return $this;
    }
    /**
     * Add item to ImportResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ImportResult $item
     * @return \ArrayType\ArrayOfImportResult
     */
    public function addToImportResult(\StructType\ImportResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ImportResult) {
            throw new \InvalidArgumentException(sprintf('The ImportResult property can only contain items of type \StructType\ImportResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImportResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ImportResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ImportResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ImportResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ImportResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ImportResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ImportResult
     */
    public function getAttributeName()
    {
        return 'ImportResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfImportResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
