<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecifyShipmentParameters StructType
 * @subpackage Structs
 */
class SpecifyShipmentParameters extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipmentDate;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $WarehouseID;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SpecifyShipmentParametersServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for SpecifyShipmentParameters
     * @uses SpecifyShipmentParameters::setDisplayName()
     * @uses SpecifyShipmentParameters::setShipmentDate()
     * @uses SpecifyShipmentParameters::setWarehouseID()
     * @uses SpecifyShipmentParameters::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $shipmentDate
     * @param \StructType\Field $warehouseID
     * @param \StructType\SpecifyShipmentParametersServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $shipmentDate = null, \StructType\Field $warehouseID = null, \StructType\SpecifyShipmentParametersServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setShipmentDate($shipmentDate)
            ->setWarehouseID($warehouseID)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\SpecifyShipmentParameters
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ShipmentDate value
     * @return \StructType\Field|null
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param \StructType\Field $shipmentDate
     * @return \StructType\SpecifyShipmentParameters
     */
    public function setShipmentDate(\StructType\Field $shipmentDate = null)
    {
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get WarehouseID value
     * @return \StructType\Field|null
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param \StructType\Field $warehouseID
     * @return \StructType\SpecifyShipmentParameters
     */
    public function setWarehouseID(\StructType\Field $warehouseID = null)
    {
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SpecifyShipmentParametersServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SpecifyShipmentParametersServiceCommands $serviceCommands
     * @return \StructType\SpecifyShipmentParameters
     */
    public function setServiceCommands(\StructType\SpecifyShipmentParametersServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecifyShipmentParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
