<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShopForRatesServicesSettings StructType
 * @subpackage Structs
 */
class ShopForRatesServicesSettings extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The OrderWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderWeight;
    /**
     * The PackageWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PackageWeight;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShopForRatesServicesSettingsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ShopForRatesServicesSettings
     * @uses ShopForRatesServicesSettings::setDisplayName()
     * @uses ShopForRatesServicesSettings::setOrderWeight()
     * @uses ShopForRatesServicesSettings::setPackageWeight()
     * @uses ShopForRatesServicesSettings::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $orderWeight
     * @param \StructType\Field $packageWeight
     * @param \StructType\ShopForRatesServicesSettingsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $orderWeight = null, \StructType\Field $packageWeight = null, \StructType\ShopForRatesServicesSettingsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setOrderWeight($orderWeight)
            ->setPackageWeight($packageWeight)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ShopForRatesServicesSettings
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get OrderWeight value
     * @return \StructType\Field|null
     */
    public function getOrderWeight()
    {
        return $this->OrderWeight;
    }
    /**
     * Set OrderWeight value
     * @param \StructType\Field $orderWeight
     * @return \StructType\ShopForRatesServicesSettings
     */
    public function setOrderWeight(\StructType\Field $orderWeight = null)
    {
        $this->OrderWeight = $orderWeight;
        return $this;
    }
    /**
     * Get PackageWeight value
     * @return \StructType\Field|null
     */
    public function getPackageWeight()
    {
        return $this->PackageWeight;
    }
    /**
     * Set PackageWeight value
     * @param \StructType\Field $packageWeight
     * @return \StructType\ShopForRatesServicesSettings
     */
    public function setPackageWeight(\StructType\Field $packageWeight = null)
    {
        $this->PackageWeight = $packageWeight;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ShopForRatesServicesSettingsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ShopForRatesServicesSettingsServiceCommands $serviceCommands
     * @return \StructType\ShopForRatesServicesSettings
     */
    public function setServiceCommands(\StructType\ShopForRatesServicesSettingsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShopForRatesServicesSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
