<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipments StructType
 * @subpackage Structs
 */
class Shipments extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ShipmentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipmentType;
    /**
     * The ShipmentNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipmentNbr;
    /**
     * The DocumentNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DocumentNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Status;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Operation;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNbr;
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipmentDate;
    /**
     * The ShippedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippedQty;
    /**
     * The ShippedWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippedWeight;
    /**
     * The ShippedVolume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippedVolume;
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InvoiceType;
    /**
     * The InvoiceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InvoiceNbr;
    /**
     * The InventoryDocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryDocType;
    /**
     * The InventoryRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryRefNbr;
    /**
     * The NoteText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShipmentsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Shipments
     * @uses Shipments::setDisplayName()
     * @uses Shipments::setShipmentType()
     * @uses Shipments::setShipmentNbr()
     * @uses Shipments::setDocumentNbr()
     * @uses Shipments::setStatus()
     * @uses Shipments::setOperation()
     * @uses Shipments::setOrderType()
     * @uses Shipments::setOrderNbr()
     * @uses Shipments::setShipmentDate()
     * @uses Shipments::setShippedQty()
     * @uses Shipments::setShippedWeight()
     * @uses Shipments::setShippedVolume()
     * @uses Shipments::setInvoiceType()
     * @uses Shipments::setInvoiceNbr()
     * @uses Shipments::setInventoryDocType()
     * @uses Shipments::setInventoryRefNbr()
     * @uses Shipments::setNoteText()
     * @uses Shipments::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $shipmentType
     * @param \StructType\Field $shipmentNbr
     * @param \StructType\Field $documentNbr
     * @param \StructType\Field $status
     * @param \StructType\Field $operation
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNbr
     * @param \StructType\Field $shipmentDate
     * @param \StructType\Field $shippedQty
     * @param \StructType\Field $shippedWeight
     * @param \StructType\Field $shippedVolume
     * @param \StructType\Field $invoiceType
     * @param \StructType\Field $invoiceNbr
     * @param \StructType\Field $inventoryDocType
     * @param \StructType\Field $inventoryRefNbr
     * @param \StructType\Field $noteText
     * @param \StructType\ShipmentsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $shipmentType = null, \StructType\Field $shipmentNbr = null, \StructType\Field $documentNbr = null, \StructType\Field $status = null, \StructType\Field $operation = null, \StructType\Field $orderType = null, \StructType\Field $orderNbr = null, \StructType\Field $shipmentDate = null, \StructType\Field $shippedQty = null, \StructType\Field $shippedWeight = null, \StructType\Field $shippedVolume = null, \StructType\Field $invoiceType = null, \StructType\Field $invoiceNbr = null, \StructType\Field $inventoryDocType = null, \StructType\Field $inventoryRefNbr = null, \StructType\Field $noteText = null, \StructType\ShipmentsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setShipmentType($shipmentType)
            ->setShipmentNbr($shipmentNbr)
            ->setDocumentNbr($documentNbr)
            ->setStatus($status)
            ->setOperation($operation)
            ->setOrderType($orderType)
            ->setOrderNbr($orderNbr)
            ->setShipmentDate($shipmentDate)
            ->setShippedQty($shippedQty)
            ->setShippedWeight($shippedWeight)
            ->setShippedVolume($shippedVolume)
            ->setInvoiceType($invoiceType)
            ->setInvoiceNbr($invoiceNbr)
            ->setInventoryDocType($inventoryDocType)
            ->setInventoryRefNbr($inventoryRefNbr)
            ->setNoteText($noteText)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Shipments
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ShipmentType value
     * @return \StructType\Field|null
     */
    public function getShipmentType()
    {
        return $this->ShipmentType;
    }
    /**
     * Set ShipmentType value
     * @param \StructType\Field $shipmentType
     * @return \StructType\Shipments
     */
    public function setShipmentType(\StructType\Field $shipmentType = null)
    {
        $this->ShipmentType = $shipmentType;
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * @return \StructType\Field|null
     */
    public function getShipmentNbr()
    {
        return $this->ShipmentNbr;
    }
    /**
     * Set ShipmentNbr value
     * @param \StructType\Field $shipmentNbr
     * @return \StructType\Shipments
     */
    public function setShipmentNbr(\StructType\Field $shipmentNbr = null)
    {
        $this->ShipmentNbr = $shipmentNbr;
        return $this;
    }
    /**
     * Get DocumentNbr value
     * @return \StructType\Field|null
     */
    public function getDocumentNbr()
    {
        return $this->DocumentNbr;
    }
    /**
     * Set DocumentNbr value
     * @param \StructType\Field $documentNbr
     * @return \StructType\Shipments
     */
    public function setDocumentNbr(\StructType\Field $documentNbr = null)
    {
        $this->DocumentNbr = $documentNbr;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Field|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Field $status
     * @return \StructType\Shipments
     */
    public function setStatus(\StructType\Field $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Operation value
     * @return \StructType\Field|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param \StructType\Field $operation
     * @return \StructType\Shipments
     */
    public function setOperation(\StructType\Field $operation = null)
    {
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\Shipments
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNbr value
     * @return \StructType\Field|null
     */
    public function getOrderNbr()
    {
        return $this->OrderNbr;
    }
    /**
     * Set OrderNbr value
     * @param \StructType\Field $orderNbr
     * @return \StructType\Shipments
     */
    public function setOrderNbr(\StructType\Field $orderNbr = null)
    {
        $this->OrderNbr = $orderNbr;
        return $this;
    }
    /**
     * Get ShipmentDate value
     * @return \StructType\Field|null
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param \StructType\Field $shipmentDate
     * @return \StructType\Shipments
     */
    public function setShipmentDate(\StructType\Field $shipmentDate = null)
    {
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get ShippedQty value
     * @return \StructType\Field|null
     */
    public function getShippedQty()
    {
        return $this->ShippedQty;
    }
    /**
     * Set ShippedQty value
     * @param \StructType\Field $shippedQty
     * @return \StructType\Shipments
     */
    public function setShippedQty(\StructType\Field $shippedQty = null)
    {
        $this->ShippedQty = $shippedQty;
        return $this;
    }
    /**
     * Get ShippedWeight value
     * @return \StructType\Field|null
     */
    public function getShippedWeight()
    {
        return $this->ShippedWeight;
    }
    /**
     * Set ShippedWeight value
     * @param \StructType\Field $shippedWeight
     * @return \StructType\Shipments
     */
    public function setShippedWeight(\StructType\Field $shippedWeight = null)
    {
        $this->ShippedWeight = $shippedWeight;
        return $this;
    }
    /**
     * Get ShippedVolume value
     * @return \StructType\Field|null
     */
    public function getShippedVolume()
    {
        return $this->ShippedVolume;
    }
    /**
     * Set ShippedVolume value
     * @param \StructType\Field $shippedVolume
     * @return \StructType\Shipments
     */
    public function setShippedVolume(\StructType\Field $shippedVolume = null)
    {
        $this->ShippedVolume = $shippedVolume;
        return $this;
    }
    /**
     * Get InvoiceType value
     * @return \StructType\Field|null
     */
    public function getInvoiceType()
    {
        return $this->InvoiceType;
    }
    /**
     * Set InvoiceType value
     * @param \StructType\Field $invoiceType
     * @return \StructType\Shipments
     */
    public function setInvoiceType(\StructType\Field $invoiceType = null)
    {
        $this->InvoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get InvoiceNbr value
     * @return \StructType\Field|null
     */
    public function getInvoiceNbr()
    {
        return $this->InvoiceNbr;
    }
    /**
     * Set InvoiceNbr value
     * @param \StructType\Field $invoiceNbr
     * @return \StructType\Shipments
     */
    public function setInvoiceNbr(\StructType\Field $invoiceNbr = null)
    {
        $this->InvoiceNbr = $invoiceNbr;
        return $this;
    }
    /**
     * Get InventoryDocType value
     * @return \StructType\Field|null
     */
    public function getInventoryDocType()
    {
        return $this->InventoryDocType;
    }
    /**
     * Set InventoryDocType value
     * @param \StructType\Field $inventoryDocType
     * @return \StructType\Shipments
     */
    public function setInventoryDocType(\StructType\Field $inventoryDocType = null)
    {
        $this->InventoryDocType = $inventoryDocType;
        return $this;
    }
    /**
     * Get InventoryRefNbr value
     * @return \StructType\Field|null
     */
    public function getInventoryRefNbr()
    {
        return $this->InventoryRefNbr;
    }
    /**
     * Set InventoryRefNbr value
     * @param \StructType\Field $inventoryRefNbr
     * @return \StructType\Shipments
     */
    public function setInventoryRefNbr(\StructType\Field $inventoryRefNbr = null)
    {
        $this->InventoryRefNbr = $inventoryRefNbr;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\Shipments
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ShipmentsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ShipmentsServiceCommands $serviceCommands
     * @return \StructType\Shipments
     */
    public function setServiceCommands(\StructType\ShipmentsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Shipments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
