<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessOrder StructType
 * @subpackage Structs
 */
class ProcessOrder extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $WarehouseID;
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipmentDate;
    /**
     * The CustomDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CustomDate;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProcessOrderServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ProcessOrder
     * @uses ProcessOrder::setDisplayName()
     * @uses ProcessOrder::setWarehouseID()
     * @uses ProcessOrder::setShipmentDate()
     * @uses ProcessOrder::setCustomDate()
     * @uses ProcessOrder::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $warehouseID
     * @param \StructType\Field $shipmentDate
     * @param \StructType\Field $customDate
     * @param \StructType\ProcessOrderServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $warehouseID = null, \StructType\Field $shipmentDate = null, \StructType\Field $customDate = null, \StructType\ProcessOrderServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setWarehouseID($warehouseID)
            ->setShipmentDate($shipmentDate)
            ->setCustomDate($customDate)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ProcessOrder
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get WarehouseID value
     * @return \StructType\Field|null
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param \StructType\Field $warehouseID
     * @return \StructType\ProcessOrder
     */
    public function setWarehouseID(\StructType\Field $warehouseID = null)
    {
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get ShipmentDate value
     * @return \StructType\Field|null
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param \StructType\Field $shipmentDate
     * @return \StructType\ProcessOrder
     */
    public function setShipmentDate(\StructType\Field $shipmentDate = null)
    {
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get CustomDate value
     * @return \StructType\Field|null
     */
    public function getCustomDate()
    {
        return $this->CustomDate;
    }
    /**
     * Set CustomDate value
     * @param \StructType\Field $customDate
     * @return \StructType\ProcessOrder
     */
    public function setCustomDate(\StructType\Field $customDate = null)
    {
        $this->CustomDate = $customDate;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ProcessOrderServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ProcessOrderServiceCommands $serviceCommands
     * @return \StructType\ProcessOrder
     */
    public function setServiceCommands(\StructType\ProcessOrderServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
