<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentSettingsDescription StructType
 * @subpackage Structs
 */
class PaymentSettingsDescription extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Description;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Value;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentSettingsDescriptionServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for PaymentSettingsDescription
     * @uses PaymentSettingsDescription::setDisplayName()
     * @uses PaymentSettingsDescription::setDescription()
     * @uses PaymentSettingsDescription::setValue()
     * @uses PaymentSettingsDescription::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $description
     * @param \StructType\Field $value
     * @param \StructType\PaymentSettingsDescriptionServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $description = null, \StructType\Field $value = null, \StructType\PaymentSettingsDescriptionServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setDescription($description)
            ->setValue($value)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\PaymentSettingsDescription
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Field|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Field $description
     * @return \StructType\PaymentSettingsDescription
     */
    public function setDescription(\StructType\Field $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Value value
     * @return \StructType\Field|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \StructType\Field $value
     * @return \StructType\PaymentSettingsDescription
     */
    public function setValue(\StructType\Field $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\PaymentSettingsDescriptionServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\PaymentSettingsDescriptionServiceCommands $serviceCommands
     * @return \StructType\PaymentSettingsDescription
     */
    public function setServiceCommands(\StructType\PaymentSettingsDescriptionServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentSettingsDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
