<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Filter StructType
 * @subpackage Structs
 */
class Filter extends AbstractStructBase
{
    /**
     * The Condition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Condition;
    /**
     * The OpenBrackets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OpenBrackets;
    /**
     * The CloseBrackets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CloseBrackets;
    /**
     * The Operator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Operator;
    /**
     * The Field
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Field;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $Value;
    /**
     * The Value2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $Value2;
    /**
     * Constructor method for Filter
     * @uses Filter::setCondition()
     * @uses Filter::setOpenBrackets()
     * @uses Filter::setCloseBrackets()
     * @uses Filter::setOperator()
     * @uses Filter::setField()
     * @uses Filter::setValue()
     * @uses Filter::setValue2()
     * @param string $condition
     * @param int $openBrackets
     * @param int $closeBrackets
     * @param string $operator
     * @param \StructType\Field $field
     * @param mixed $value
     * @param mixed $value2
     */
    public function __construct($condition = null, $openBrackets = null, $closeBrackets = null, $operator = null, \StructType\Field $field = null, $value = null, $value2 = null)
    {
        $this
            ->setCondition($condition)
            ->setOpenBrackets($openBrackets)
            ->setCloseBrackets($closeBrackets)
            ->setOperator($operator)
            ->setField($field)
            ->setValue($value)
            ->setValue2($value2);
    }
    /**
     * Get Condition value
     * @return string
     */
    public function getCondition()
    {
        return $this->Condition;
    }
    /**
     * Set Condition value
     * @uses \EnumType\FilterCondition::valueIsValid()
     * @uses \EnumType\FilterCondition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $condition
     * @return \StructType\Filter
     */
    public function setCondition($condition = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FilterCondition::valueIsValid($condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FilterCondition', is_array($condition) ? implode(', ', $condition) : var_export($condition, true), implode(', ', \EnumType\FilterCondition::getValidValues())), __LINE__);
        }
        $this->Condition = $condition;
        return $this;
    }
    /**
     * Get OpenBrackets value
     * @return int
     */
    public function getOpenBrackets()
    {
        return $this->OpenBrackets;
    }
    /**
     * Set OpenBrackets value
     * @param int $openBrackets
     * @return \StructType\Filter
     */
    public function setOpenBrackets($openBrackets = null)
    {
        // validation for constraint: int
        if (!is_null($openBrackets) && !(is_int($openBrackets) || ctype_digit($openBrackets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openBrackets, true), gettype($openBrackets)), __LINE__);
        }
        $this->OpenBrackets = $openBrackets;
        return $this;
    }
    /**
     * Get CloseBrackets value
     * @return int
     */
    public function getCloseBrackets()
    {
        return $this->CloseBrackets;
    }
    /**
     * Set CloseBrackets value
     * @param int $closeBrackets
     * @return \StructType\Filter
     */
    public function setCloseBrackets($closeBrackets = null)
    {
        // validation for constraint: int
        if (!is_null($closeBrackets) && !(is_int($closeBrackets) || ctype_digit($closeBrackets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($closeBrackets, true), gettype($closeBrackets)), __LINE__);
        }
        $this->CloseBrackets = $closeBrackets;
        return $this;
    }
    /**
     * Get Operator value
     * @return string
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @uses \EnumType\FilterOperator::valueIsValid()
     * @uses \EnumType\FilterOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\Filter
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FilterOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FilterOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\FilterOperator::getValidValues())), __LINE__);
        }
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Get Field value
     * @return \StructType\Field|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * Set Field value
     * @param \StructType\Field $field
     * @return \StructType\Filter
     */
    public function setField(\StructType\Field $field = null)
    {
        $this->Field = $field;
        return $this;
    }
    /**
     * Get Value value
     * @return mixed|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param mixed $value
     * @return \StructType\Filter
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Value2 value
     * @return mixed|null
     */
    public function getValue2()
    {
        return $this->Value2;
    }
    /**
     * Set Value2 value
     * @param mixed $value2
     * @return \StructType\Filter
     */
    public function setValue2($value2 = null)
    {
        $this->Value2 = $value2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Filter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
