<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentDetails StructType
 * @subpackage Structs
 */
class DocumentDetails extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Branch;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNbr;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineNbr;
    /**
     * The LineOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineOrder;
    /**
     * The LineType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineType;
    /**
     * The InvoiceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InvoiceNbr;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Operation;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryID;
    /**
     * The ServiceAppointmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ServiceAppointmentDate;
    /**
     * The EquipmentAction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EquipmentAction;
    /**
     * The EquipmentActionComment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EquipmentActionComment;
    /**
     * The TargetEquipmentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TargetEquipmentID;
    /**
     * The ModelEquipmentLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ModelEquipmentLineNbr;
    /**
     * The ComponentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ComponentID;
    /**
     * The ComponentLineRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ComponentLineRef;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LocationID;
    /**
     * The AppointmentNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AppointmentNbr;
    /**
     * The ServiceOrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ServiceOrderNbr;
    /**
     * The RequireAppointment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RequireAppointment;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Subitem;
    /**
     * The AutoCreateIssue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AutoCreateIssue;
    /**
     * The FreeItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FreeItem;
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Warehouse;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Location;
    /**
     * The LineDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineDescription;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Quantity;
    /**
     * The BaseOrderQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $BaseOrderQty;
    /**
     * The QtyOnShipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyOnShipments;
    /**
     * The OpenQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OpenQty;
    /**
     * The UnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnitCost;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnitPrice;
    /**
     * The ManualPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ManualPrice;
    /**
     * The ExtPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExtPrice;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountPercent;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountAmount;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountCode;
    /**
     * The DiscountSequence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountSequence;
    /**
     * The ManualDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ManualDiscount;
    /**
     * The DiscUnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscUnitPrice;
    /**
     * The AverageCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AverageCost;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Amount;
    /**
     * The TermStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TermStartDate;
    /**
     * The TermEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TermEndDate;
    /**
     * The UnbilledAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnbilledAmount;
    /**
     * The RequestedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RequestedOn;
    /**
     * The ShipOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipOn;
    /**
     * The ShippingRule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippingRule;
    /**
     * The UndershipThreshold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UndershipThreshold;
    /**
     * The OvershipThreshold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OvershipThreshold;
    /**
     * The Completed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Completed;
    /**
     * The MarkForPO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MarkForPO;
    /**
     * The POSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $POSource;
    /**
     * The LotSerialNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LotSerialNbr;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExpirationDate;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReasonCode;
    /**
     * The SalespersonID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SalespersonID;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxCategory;
    /**
     * The EntityUsageType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EntityUsageType;
    /**
     * The Commissionable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Commissionable;
    /**
     * The AlternateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AlternateID;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Account;
    /**
     * The Subaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Subaccount;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProjectTask;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CostCode;
    /**
     * The UnitPriceForDR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnitPriceForDR;
    /**
     * The DiscountPercentForDR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountPercentForDR;
    /**
     * The ROTOrRUTDeductible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ROTOrRUTDeductible;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ItemType;
    /**
     * The TypeOfWork
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TypeOfWork;
    /**
     * The DeductibleAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DeductibleAmount;
    /**
     * The NoteText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Availability;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DocumentDetailsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for DocumentDetails
     * @uses DocumentDetails::setDisplayName()
     * @uses DocumentDetails::setBranch()
     * @uses DocumentDetails::setOrderType()
     * @uses DocumentDetails::setOrderNbr()
     * @uses DocumentDetails::setLineNbr()
     * @uses DocumentDetails::setLineOrder()
     * @uses DocumentDetails::setLineType()
     * @uses DocumentDetails::setInvoiceNbr()
     * @uses DocumentDetails::setOperation()
     * @uses DocumentDetails::setInventoryID()
     * @uses DocumentDetails::setServiceAppointmentDate()
     * @uses DocumentDetails::setEquipmentAction()
     * @uses DocumentDetails::setEquipmentActionComment()
     * @uses DocumentDetails::setTargetEquipmentID()
     * @uses DocumentDetails::setModelEquipmentLineNbr()
     * @uses DocumentDetails::setComponentID()
     * @uses DocumentDetails::setComponentLineRef()
     * @uses DocumentDetails::setLocationID()
     * @uses DocumentDetails::setAppointmentNbr()
     * @uses DocumentDetails::setServiceOrderNbr()
     * @uses DocumentDetails::setRequireAppointment()
     * @uses DocumentDetails::setSubitem()
     * @uses DocumentDetails::setAutoCreateIssue()
     * @uses DocumentDetails::setFreeItem()
     * @uses DocumentDetails::setWarehouse()
     * @uses DocumentDetails::setLocation()
     * @uses DocumentDetails::setLineDescription()
     * @uses DocumentDetails::setUOM()
     * @uses DocumentDetails::setQuantity()
     * @uses DocumentDetails::setBaseOrderQty()
     * @uses DocumentDetails::setQtyOnShipments()
     * @uses DocumentDetails::setOpenQty()
     * @uses DocumentDetails::setUnitCost()
     * @uses DocumentDetails::setUnitPrice()
     * @uses DocumentDetails::setManualPrice()
     * @uses DocumentDetails::setExtPrice()
     * @uses DocumentDetails::setDiscountPercent()
     * @uses DocumentDetails::setDiscountAmount()
     * @uses DocumentDetails::setDiscountCode()
     * @uses DocumentDetails::setDiscountSequence()
     * @uses DocumentDetails::setManualDiscount()
     * @uses DocumentDetails::setDiscUnitPrice()
     * @uses DocumentDetails::setAverageCost()
     * @uses DocumentDetails::setAmount()
     * @uses DocumentDetails::setTermStartDate()
     * @uses DocumentDetails::setTermEndDate()
     * @uses DocumentDetails::setUnbilledAmount()
     * @uses DocumentDetails::setRequestedOn()
     * @uses DocumentDetails::setShipOn()
     * @uses DocumentDetails::setShippingRule()
     * @uses DocumentDetails::setUndershipThreshold()
     * @uses DocumentDetails::setOvershipThreshold()
     * @uses DocumentDetails::setCompleted()
     * @uses DocumentDetails::setMarkForPO()
     * @uses DocumentDetails::setPOSource()
     * @uses DocumentDetails::setLotSerialNbr()
     * @uses DocumentDetails::setExpirationDate()
     * @uses DocumentDetails::setReasonCode()
     * @uses DocumentDetails::setSalespersonID()
     * @uses DocumentDetails::setTaxCategory()
     * @uses DocumentDetails::setEntityUsageType()
     * @uses DocumentDetails::setCommissionable()
     * @uses DocumentDetails::setAlternateID()
     * @uses DocumentDetails::setAccount()
     * @uses DocumentDetails::setSubaccount()
     * @uses DocumentDetails::setProjectTask()
     * @uses DocumentDetails::setCostCode()
     * @uses DocumentDetails::setUnitPriceForDR()
     * @uses DocumentDetails::setDiscountPercentForDR()
     * @uses DocumentDetails::setROTOrRUTDeductible()
     * @uses DocumentDetails::setItemType()
     * @uses DocumentDetails::setTypeOfWork()
     * @uses DocumentDetails::setDeductibleAmount()
     * @uses DocumentDetails::setNoteText()
     * @uses DocumentDetails::setAvailability()
     * @uses DocumentDetails::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $branch
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNbr
     * @param \StructType\Field $lineNbr
     * @param \StructType\Field $lineOrder
     * @param \StructType\Field $lineType
     * @param \StructType\Field $invoiceNbr
     * @param \StructType\Field $operation
     * @param \StructType\Field $inventoryID
     * @param \StructType\Field $serviceAppointmentDate
     * @param \StructType\Field $equipmentAction
     * @param \StructType\Field $equipmentActionComment
     * @param \StructType\Field $targetEquipmentID
     * @param \StructType\Field $modelEquipmentLineNbr
     * @param \StructType\Field $componentID
     * @param \StructType\Field $componentLineRef
     * @param \StructType\Field $locationID
     * @param \StructType\Field $appointmentNbr
     * @param \StructType\Field $serviceOrderNbr
     * @param \StructType\Field $requireAppointment
     * @param \StructType\Field $subitem
     * @param \StructType\Field $autoCreateIssue
     * @param \StructType\Field $freeItem
     * @param \StructType\Field $warehouse
     * @param \StructType\Field $location
     * @param \StructType\Field $lineDescription
     * @param \StructType\Field $uOM
     * @param \StructType\Field $quantity
     * @param \StructType\Field $baseOrderQty
     * @param \StructType\Field $qtyOnShipments
     * @param \StructType\Field $openQty
     * @param \StructType\Field $unitCost
     * @param \StructType\Field $unitPrice
     * @param \StructType\Field $manualPrice
     * @param \StructType\Field $extPrice
     * @param \StructType\Field $discountPercent
     * @param \StructType\Field $discountAmount
     * @param \StructType\Field $discountCode
     * @param \StructType\Field $discountSequence
     * @param \StructType\Field $manualDiscount
     * @param \StructType\Field $discUnitPrice
     * @param \StructType\Field $averageCost
     * @param \StructType\Field $amount
     * @param \StructType\Field $termStartDate
     * @param \StructType\Field $termEndDate
     * @param \StructType\Field $unbilledAmount
     * @param \StructType\Field $requestedOn
     * @param \StructType\Field $shipOn
     * @param \StructType\Field $shippingRule
     * @param \StructType\Field $undershipThreshold
     * @param \StructType\Field $overshipThreshold
     * @param \StructType\Field $completed
     * @param \StructType\Field $markForPO
     * @param \StructType\Field $pOSource
     * @param \StructType\Field $lotSerialNbr
     * @param \StructType\Field $expirationDate
     * @param \StructType\Field $reasonCode
     * @param \StructType\Field $salespersonID
     * @param \StructType\Field $taxCategory
     * @param \StructType\Field $entityUsageType
     * @param \StructType\Field $commissionable
     * @param \StructType\Field $alternateID
     * @param \StructType\Field $account
     * @param \StructType\Field $subaccount
     * @param \StructType\Field $projectTask
     * @param \StructType\Field $costCode
     * @param \StructType\Field $unitPriceForDR
     * @param \StructType\Field $discountPercentForDR
     * @param \StructType\Field $rOTOrRUTDeductible
     * @param \StructType\Field $itemType
     * @param \StructType\Field $typeOfWork
     * @param \StructType\Field $deductibleAmount
     * @param \StructType\Field $noteText
     * @param \StructType\Field $availability
     * @param \StructType\DocumentDetailsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $branch = null, \StructType\Field $orderType = null, \StructType\Field $orderNbr = null, \StructType\Field $lineNbr = null, \StructType\Field $lineOrder = null, \StructType\Field $lineType = null, \StructType\Field $invoiceNbr = null, \StructType\Field $operation = null, \StructType\Field $inventoryID = null, \StructType\Field $serviceAppointmentDate = null, \StructType\Field $equipmentAction = null, \StructType\Field $equipmentActionComment = null, \StructType\Field $targetEquipmentID = null, \StructType\Field $modelEquipmentLineNbr = null, \StructType\Field $componentID = null, \StructType\Field $componentLineRef = null, \StructType\Field $locationID = null, \StructType\Field $appointmentNbr = null, \StructType\Field $serviceOrderNbr = null, \StructType\Field $requireAppointment = null, \StructType\Field $subitem = null, \StructType\Field $autoCreateIssue = null, \StructType\Field $freeItem = null, \StructType\Field $warehouse = null, \StructType\Field $location = null, \StructType\Field $lineDescription = null, \StructType\Field $uOM = null, \StructType\Field $quantity = null, \StructType\Field $baseOrderQty = null, \StructType\Field $qtyOnShipments = null, \StructType\Field $openQty = null, \StructType\Field $unitCost = null, \StructType\Field $unitPrice = null, \StructType\Field $manualPrice = null, \StructType\Field $extPrice = null, \StructType\Field $discountPercent = null, \StructType\Field $discountAmount = null, \StructType\Field $discountCode = null, \StructType\Field $discountSequence = null, \StructType\Field $manualDiscount = null, \StructType\Field $discUnitPrice = null, \StructType\Field $averageCost = null, \StructType\Field $amount = null, \StructType\Field $termStartDate = null, \StructType\Field $termEndDate = null, \StructType\Field $unbilledAmount = null, \StructType\Field $requestedOn = null, \StructType\Field $shipOn = null, \StructType\Field $shippingRule = null, \StructType\Field $undershipThreshold = null, \StructType\Field $overshipThreshold = null, \StructType\Field $completed = null, \StructType\Field $markForPO = null, \StructType\Field $pOSource = null, \StructType\Field $lotSerialNbr = null, \StructType\Field $expirationDate = null, \StructType\Field $reasonCode = null, \StructType\Field $salespersonID = null, \StructType\Field $taxCategory = null, \StructType\Field $entityUsageType = null, \StructType\Field $commissionable = null, \StructType\Field $alternateID = null, \StructType\Field $account = null, \StructType\Field $subaccount = null, \StructType\Field $projectTask = null, \StructType\Field $costCode = null, \StructType\Field $unitPriceForDR = null, \StructType\Field $discountPercentForDR = null, \StructType\Field $rOTOrRUTDeductible = null, \StructType\Field $itemType = null, \StructType\Field $typeOfWork = null, \StructType\Field $deductibleAmount = null, \StructType\Field $noteText = null, \StructType\Field $availability = null, \StructType\DocumentDetailsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setBranch($branch)
            ->setOrderType($orderType)
            ->setOrderNbr($orderNbr)
            ->setLineNbr($lineNbr)
            ->setLineOrder($lineOrder)
            ->setLineType($lineType)
            ->setInvoiceNbr($invoiceNbr)
            ->setOperation($operation)
            ->setInventoryID($inventoryID)
            ->setServiceAppointmentDate($serviceAppointmentDate)
            ->setEquipmentAction($equipmentAction)
            ->setEquipmentActionComment($equipmentActionComment)
            ->setTargetEquipmentID($targetEquipmentID)
            ->setModelEquipmentLineNbr($modelEquipmentLineNbr)
            ->setComponentID($componentID)
            ->setComponentLineRef($componentLineRef)
            ->setLocationID($locationID)
            ->setAppointmentNbr($appointmentNbr)
            ->setServiceOrderNbr($serviceOrderNbr)
            ->setRequireAppointment($requireAppointment)
            ->setSubitem($subitem)
            ->setAutoCreateIssue($autoCreateIssue)
            ->setFreeItem($freeItem)
            ->setWarehouse($warehouse)
            ->setLocation($location)
            ->setLineDescription($lineDescription)
            ->setUOM($uOM)
            ->setQuantity($quantity)
            ->setBaseOrderQty($baseOrderQty)
            ->setQtyOnShipments($qtyOnShipments)
            ->setOpenQty($openQty)
            ->setUnitCost($unitCost)
            ->setUnitPrice($unitPrice)
            ->setManualPrice($manualPrice)
            ->setExtPrice($extPrice)
            ->setDiscountPercent($discountPercent)
            ->setDiscountAmount($discountAmount)
            ->setDiscountCode($discountCode)
            ->setDiscountSequence($discountSequence)
            ->setManualDiscount($manualDiscount)
            ->setDiscUnitPrice($discUnitPrice)
            ->setAverageCost($averageCost)
            ->setAmount($amount)
            ->setTermStartDate($termStartDate)
            ->setTermEndDate($termEndDate)
            ->setUnbilledAmount($unbilledAmount)
            ->setRequestedOn($requestedOn)
            ->setShipOn($shipOn)
            ->setShippingRule($shippingRule)
            ->setUndershipThreshold($undershipThreshold)
            ->setOvershipThreshold($overshipThreshold)
            ->setCompleted($completed)
            ->setMarkForPO($markForPO)
            ->setPOSource($pOSource)
            ->setLotSerialNbr($lotSerialNbr)
            ->setExpirationDate($expirationDate)
            ->setReasonCode($reasonCode)
            ->setSalespersonID($salespersonID)
            ->setTaxCategory($taxCategory)
            ->setEntityUsageType($entityUsageType)
            ->setCommissionable($commissionable)
            ->setAlternateID($alternateID)
            ->setAccount($account)
            ->setSubaccount($subaccount)
            ->setProjectTask($projectTask)
            ->setCostCode($costCode)
            ->setUnitPriceForDR($unitPriceForDR)
            ->setDiscountPercentForDR($discountPercentForDR)
            ->setROTOrRUTDeductible($rOTOrRUTDeductible)
            ->setItemType($itemType)
            ->setTypeOfWork($typeOfWork)
            ->setDeductibleAmount($deductibleAmount)
            ->setNoteText($noteText)
            ->setAvailability($availability)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\DocumentDetails
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Branch value
     * @return \StructType\Field|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * Set Branch value
     * @param \StructType\Field $branch
     * @return \StructType\DocumentDetails
     */
    public function setBranch(\StructType\Field $branch = null)
    {
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\DocumentDetails
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNbr value
     * @return \StructType\Field|null
     */
    public function getOrderNbr()
    {
        return $this->OrderNbr;
    }
    /**
     * Set OrderNbr value
     * @param \StructType\Field $orderNbr
     * @return \StructType\DocumentDetails
     */
    public function setOrderNbr(\StructType\Field $orderNbr = null)
    {
        $this->OrderNbr = $orderNbr;
        return $this;
    }
    /**
     * Get LineNbr value
     * @return \StructType\Field|null
     */
    public function getLineNbr()
    {
        return $this->LineNbr;
    }
    /**
     * Set LineNbr value
     * @param \StructType\Field $lineNbr
     * @return \StructType\DocumentDetails
     */
    public function setLineNbr(\StructType\Field $lineNbr = null)
    {
        $this->LineNbr = $lineNbr;
        return $this;
    }
    /**
     * Get LineOrder value
     * @return \StructType\Field|null
     */
    public function getLineOrder()
    {
        return $this->LineOrder;
    }
    /**
     * Set LineOrder value
     * @param \StructType\Field $lineOrder
     * @return \StructType\DocumentDetails
     */
    public function setLineOrder(\StructType\Field $lineOrder = null)
    {
        $this->LineOrder = $lineOrder;
        return $this;
    }
    /**
     * Get LineType value
     * @return \StructType\Field|null
     */
    public function getLineType()
    {
        return $this->LineType;
    }
    /**
     * Set LineType value
     * @param \StructType\Field $lineType
     * @return \StructType\DocumentDetails
     */
    public function setLineType(\StructType\Field $lineType = null)
    {
        $this->LineType = $lineType;
        return $this;
    }
    /**
     * Get InvoiceNbr value
     * @return \StructType\Field|null
     */
    public function getInvoiceNbr()
    {
        return $this->InvoiceNbr;
    }
    /**
     * Set InvoiceNbr value
     * @param \StructType\Field $invoiceNbr
     * @return \StructType\DocumentDetails
     */
    public function setInvoiceNbr(\StructType\Field $invoiceNbr = null)
    {
        $this->InvoiceNbr = $invoiceNbr;
        return $this;
    }
    /**
     * Get Operation value
     * @return \StructType\Field|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param \StructType\Field $operation
     * @return \StructType\DocumentDetails
     */
    public function setOperation(\StructType\Field $operation = null)
    {
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get InventoryID value
     * @return \StructType\Field|null
     */
    public function getInventoryID()
    {
        return $this->InventoryID;
    }
    /**
     * Set InventoryID value
     * @param \StructType\Field $inventoryID
     * @return \StructType\DocumentDetails
     */
    public function setInventoryID(\StructType\Field $inventoryID = null)
    {
        $this->InventoryID = $inventoryID;
        return $this;
    }
    /**
     * Get ServiceAppointmentDate value
     * @return \StructType\Field|null
     */
    public function getServiceAppointmentDate()
    {
        return $this->ServiceAppointmentDate;
    }
    /**
     * Set ServiceAppointmentDate value
     * @param \StructType\Field $serviceAppointmentDate
     * @return \StructType\DocumentDetails
     */
    public function setServiceAppointmentDate(\StructType\Field $serviceAppointmentDate = null)
    {
        $this->ServiceAppointmentDate = $serviceAppointmentDate;
        return $this;
    }
    /**
     * Get EquipmentAction value
     * @return \StructType\Field|null
     */
    public function getEquipmentAction()
    {
        return $this->EquipmentAction;
    }
    /**
     * Set EquipmentAction value
     * @param \StructType\Field $equipmentAction
     * @return \StructType\DocumentDetails
     */
    public function setEquipmentAction(\StructType\Field $equipmentAction = null)
    {
        $this->EquipmentAction = $equipmentAction;
        return $this;
    }
    /**
     * Get EquipmentActionComment value
     * @return \StructType\Field|null
     */
    public function getEquipmentActionComment()
    {
        return $this->EquipmentActionComment;
    }
    /**
     * Set EquipmentActionComment value
     * @param \StructType\Field $equipmentActionComment
     * @return \StructType\DocumentDetails
     */
    public function setEquipmentActionComment(\StructType\Field $equipmentActionComment = null)
    {
        $this->EquipmentActionComment = $equipmentActionComment;
        return $this;
    }
    /**
     * Get TargetEquipmentID value
     * @return \StructType\Field|null
     */
    public function getTargetEquipmentID()
    {
        return $this->TargetEquipmentID;
    }
    /**
     * Set TargetEquipmentID value
     * @param \StructType\Field $targetEquipmentID
     * @return \StructType\DocumentDetails
     */
    public function setTargetEquipmentID(\StructType\Field $targetEquipmentID = null)
    {
        $this->TargetEquipmentID = $targetEquipmentID;
        return $this;
    }
    /**
     * Get ModelEquipmentLineNbr value
     * @return \StructType\Field|null
     */
    public function getModelEquipmentLineNbr()
    {
        return $this->ModelEquipmentLineNbr;
    }
    /**
     * Set ModelEquipmentLineNbr value
     * @param \StructType\Field $modelEquipmentLineNbr
     * @return \StructType\DocumentDetails
     */
    public function setModelEquipmentLineNbr(\StructType\Field $modelEquipmentLineNbr = null)
    {
        $this->ModelEquipmentLineNbr = $modelEquipmentLineNbr;
        return $this;
    }
    /**
     * Get ComponentID value
     * @return \StructType\Field|null
     */
    public function getComponentID()
    {
        return $this->ComponentID;
    }
    /**
     * Set ComponentID value
     * @param \StructType\Field $componentID
     * @return \StructType\DocumentDetails
     */
    public function setComponentID(\StructType\Field $componentID = null)
    {
        $this->ComponentID = $componentID;
        return $this;
    }
    /**
     * Get ComponentLineRef value
     * @return \StructType\Field|null
     */
    public function getComponentLineRef()
    {
        return $this->ComponentLineRef;
    }
    /**
     * Set ComponentLineRef value
     * @param \StructType\Field $componentLineRef
     * @return \StructType\DocumentDetails
     */
    public function setComponentLineRef(\StructType\Field $componentLineRef = null)
    {
        $this->ComponentLineRef = $componentLineRef;
        return $this;
    }
    /**
     * Get LocationID value
     * @return \StructType\Field|null
     */
    public function getLocationID()
    {
        return $this->LocationID;
    }
    /**
     * Set LocationID value
     * @param \StructType\Field $locationID
     * @return \StructType\DocumentDetails
     */
    public function setLocationID(\StructType\Field $locationID = null)
    {
        $this->LocationID = $locationID;
        return $this;
    }
    /**
     * Get AppointmentNbr value
     * @return \StructType\Field|null
     */
    public function getAppointmentNbr()
    {
        return $this->AppointmentNbr;
    }
    /**
     * Set AppointmentNbr value
     * @param \StructType\Field $appointmentNbr
     * @return \StructType\DocumentDetails
     */
    public function setAppointmentNbr(\StructType\Field $appointmentNbr = null)
    {
        $this->AppointmentNbr = $appointmentNbr;
        return $this;
    }
    /**
     * Get ServiceOrderNbr value
     * @return \StructType\Field|null
     */
    public function getServiceOrderNbr()
    {
        return $this->ServiceOrderNbr;
    }
    /**
     * Set ServiceOrderNbr value
     * @param \StructType\Field $serviceOrderNbr
     * @return \StructType\DocumentDetails
     */
    public function setServiceOrderNbr(\StructType\Field $serviceOrderNbr = null)
    {
        $this->ServiceOrderNbr = $serviceOrderNbr;
        return $this;
    }
    /**
     * Get RequireAppointment value
     * @return \StructType\Field|null
     */
    public function getRequireAppointment()
    {
        return $this->RequireAppointment;
    }
    /**
     * Set RequireAppointment value
     * @param \StructType\Field $requireAppointment
     * @return \StructType\DocumentDetails
     */
    public function setRequireAppointment(\StructType\Field $requireAppointment = null)
    {
        $this->RequireAppointment = $requireAppointment;
        return $this;
    }
    /**
     * Get Subitem value
     * @return \StructType\Field|null
     */
    public function getSubitem()
    {
        return $this->Subitem;
    }
    /**
     * Set Subitem value
     * @param \StructType\Field $subitem
     * @return \StructType\DocumentDetails
     */
    public function setSubitem(\StructType\Field $subitem = null)
    {
        $this->Subitem = $subitem;
        return $this;
    }
    /**
     * Get AutoCreateIssue value
     * @return \StructType\Field|null
     */
    public function getAutoCreateIssue()
    {
        return $this->AutoCreateIssue;
    }
    /**
     * Set AutoCreateIssue value
     * @param \StructType\Field $autoCreateIssue
     * @return \StructType\DocumentDetails
     */
    public function setAutoCreateIssue(\StructType\Field $autoCreateIssue = null)
    {
        $this->AutoCreateIssue = $autoCreateIssue;
        return $this;
    }
    /**
     * Get FreeItem value
     * @return \StructType\Field|null
     */
    public function getFreeItem()
    {
        return $this->FreeItem;
    }
    /**
     * Set FreeItem value
     * @param \StructType\Field $freeItem
     * @return \StructType\DocumentDetails
     */
    public function setFreeItem(\StructType\Field $freeItem = null)
    {
        $this->FreeItem = $freeItem;
        return $this;
    }
    /**
     * Get Warehouse value
     * @return \StructType\Field|null
     */
    public function getWarehouse()
    {
        return $this->Warehouse;
    }
    /**
     * Set Warehouse value
     * @param \StructType\Field $warehouse
     * @return \StructType\DocumentDetails
     */
    public function setWarehouse(\StructType\Field $warehouse = null)
    {
        $this->Warehouse = $warehouse;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Field|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Field $location
     * @return \StructType\DocumentDetails
     */
    public function setLocation(\StructType\Field $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get LineDescription value
     * @return \StructType\Field|null
     */
    public function getLineDescription()
    {
        return $this->LineDescription;
    }
    /**
     * Set LineDescription value
     * @param \StructType\Field $lineDescription
     * @return \StructType\DocumentDetails
     */
    public function setLineDescription(\StructType\Field $lineDescription = null)
    {
        $this->LineDescription = $lineDescription;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\DocumentDetails
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \StructType\Field|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \StructType\Field $quantity
     * @return \StructType\DocumentDetails
     */
    public function setQuantity(\StructType\Field $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get BaseOrderQty value
     * @return \StructType\Field|null
     */
    public function getBaseOrderQty()
    {
        return $this->BaseOrderQty;
    }
    /**
     * Set BaseOrderQty value
     * @param \StructType\Field $baseOrderQty
     * @return \StructType\DocumentDetails
     */
    public function setBaseOrderQty(\StructType\Field $baseOrderQty = null)
    {
        $this->BaseOrderQty = $baseOrderQty;
        return $this;
    }
    /**
     * Get QtyOnShipments value
     * @return \StructType\Field|null
     */
    public function getQtyOnShipments()
    {
        return $this->QtyOnShipments;
    }
    /**
     * Set QtyOnShipments value
     * @param \StructType\Field $qtyOnShipments
     * @return \StructType\DocumentDetails
     */
    public function setQtyOnShipments(\StructType\Field $qtyOnShipments = null)
    {
        $this->QtyOnShipments = $qtyOnShipments;
        return $this;
    }
    /**
     * Get OpenQty value
     * @return \StructType\Field|null
     */
    public function getOpenQty()
    {
        return $this->OpenQty;
    }
    /**
     * Set OpenQty value
     * @param \StructType\Field $openQty
     * @return \StructType\DocumentDetails
     */
    public function setOpenQty(\StructType\Field $openQty = null)
    {
        $this->OpenQty = $openQty;
        return $this;
    }
    /**
     * Get UnitCost value
     * @return \StructType\Field|null
     */
    public function getUnitCost()
    {
        return $this->UnitCost;
    }
    /**
     * Set UnitCost value
     * @param \StructType\Field $unitCost
     * @return \StructType\DocumentDetails
     */
    public function setUnitCost(\StructType\Field $unitCost = null)
    {
        $this->UnitCost = $unitCost;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return \StructType\Field|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param \StructType\Field $unitPrice
     * @return \StructType\DocumentDetails
     */
    public function setUnitPrice(\StructType\Field $unitPrice = null)
    {
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get ManualPrice value
     * @return \StructType\Field|null
     */
    public function getManualPrice()
    {
        return $this->ManualPrice;
    }
    /**
     * Set ManualPrice value
     * @param \StructType\Field $manualPrice
     * @return \StructType\DocumentDetails
     */
    public function setManualPrice(\StructType\Field $manualPrice = null)
    {
        $this->ManualPrice = $manualPrice;
        return $this;
    }
    /**
     * Get ExtPrice value
     * @return \StructType\Field|null
     */
    public function getExtPrice()
    {
        return $this->ExtPrice;
    }
    /**
     * Set ExtPrice value
     * @param \StructType\Field $extPrice
     * @return \StructType\DocumentDetails
     */
    public function setExtPrice(\StructType\Field $extPrice = null)
    {
        $this->ExtPrice = $extPrice;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return \StructType\Field|null
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param \StructType\Field $discountPercent
     * @return \StructType\DocumentDetails
     */
    public function setDiscountPercent(\StructType\Field $discountPercent = null)
    {
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return \StructType\Field|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param \StructType\Field $discountAmount
     * @return \StructType\DocumentDetails
     */
    public function setDiscountAmount(\StructType\Field $discountAmount = null)
    {
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return \StructType\Field|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param \StructType\Field $discountCode
     * @return \StructType\DocumentDetails
     */
    public function setDiscountCode(\StructType\Field $discountCode = null)
    {
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get DiscountSequence value
     * @return \StructType\Field|null
     */
    public function getDiscountSequence()
    {
        return $this->DiscountSequence;
    }
    /**
     * Set DiscountSequence value
     * @param \StructType\Field $discountSequence
     * @return \StructType\DocumentDetails
     */
    public function setDiscountSequence(\StructType\Field $discountSequence = null)
    {
        $this->DiscountSequence = $discountSequence;
        return $this;
    }
    /**
     * Get ManualDiscount value
     * @return \StructType\Field|null
     */
    public function getManualDiscount()
    {
        return $this->ManualDiscount;
    }
    /**
     * Set ManualDiscount value
     * @param \StructType\Field $manualDiscount
     * @return \StructType\DocumentDetails
     */
    public function setManualDiscount(\StructType\Field $manualDiscount = null)
    {
        $this->ManualDiscount = $manualDiscount;
        return $this;
    }
    /**
     * Get DiscUnitPrice value
     * @return \StructType\Field|null
     */
    public function getDiscUnitPrice()
    {
        return $this->DiscUnitPrice;
    }
    /**
     * Set DiscUnitPrice value
     * @param \StructType\Field $discUnitPrice
     * @return \StructType\DocumentDetails
     */
    public function setDiscUnitPrice(\StructType\Field $discUnitPrice = null)
    {
        $this->DiscUnitPrice = $discUnitPrice;
        return $this;
    }
    /**
     * Get AverageCost value
     * @return \StructType\Field|null
     */
    public function getAverageCost()
    {
        return $this->AverageCost;
    }
    /**
     * Set AverageCost value
     * @param \StructType\Field $averageCost
     * @return \StructType\DocumentDetails
     */
    public function setAverageCost(\StructType\Field $averageCost = null)
    {
        $this->AverageCost = $averageCost;
        return $this;
    }
    /**
     * Get Amount value
     * @return \StructType\Field|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\Field $amount
     * @return \StructType\DocumentDetails
     */
    public function setAmount(\StructType\Field $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TermStartDate value
     * @return \StructType\Field|null
     */
    public function getTermStartDate()
    {
        return $this->TermStartDate;
    }
    /**
     * Set TermStartDate value
     * @param \StructType\Field $termStartDate
     * @return \StructType\DocumentDetails
     */
    public function setTermStartDate(\StructType\Field $termStartDate = null)
    {
        $this->TermStartDate = $termStartDate;
        return $this;
    }
    /**
     * Get TermEndDate value
     * @return \StructType\Field|null
     */
    public function getTermEndDate()
    {
        return $this->TermEndDate;
    }
    /**
     * Set TermEndDate value
     * @param \StructType\Field $termEndDate
     * @return \StructType\DocumentDetails
     */
    public function setTermEndDate(\StructType\Field $termEndDate = null)
    {
        $this->TermEndDate = $termEndDate;
        return $this;
    }
    /**
     * Get UnbilledAmount value
     * @return \StructType\Field|null
     */
    public function getUnbilledAmount()
    {
        return $this->UnbilledAmount;
    }
    /**
     * Set UnbilledAmount value
     * @param \StructType\Field $unbilledAmount
     * @return \StructType\DocumentDetails
     */
    public function setUnbilledAmount(\StructType\Field $unbilledAmount = null)
    {
        $this->UnbilledAmount = $unbilledAmount;
        return $this;
    }
    /**
     * Get RequestedOn value
     * @return \StructType\Field|null
     */
    public function getRequestedOn()
    {
        return $this->RequestedOn;
    }
    /**
     * Set RequestedOn value
     * @param \StructType\Field $requestedOn
     * @return \StructType\DocumentDetails
     */
    public function setRequestedOn(\StructType\Field $requestedOn = null)
    {
        $this->RequestedOn = $requestedOn;
        return $this;
    }
    /**
     * Get ShipOn value
     * @return \StructType\Field|null
     */
    public function getShipOn()
    {
        return $this->ShipOn;
    }
    /**
     * Set ShipOn value
     * @param \StructType\Field $shipOn
     * @return \StructType\DocumentDetails
     */
    public function setShipOn(\StructType\Field $shipOn = null)
    {
        $this->ShipOn = $shipOn;
        return $this;
    }
    /**
     * Get ShippingRule value
     * @return \StructType\Field|null
     */
    public function getShippingRule()
    {
        return $this->ShippingRule;
    }
    /**
     * Set ShippingRule value
     * @param \StructType\Field $shippingRule
     * @return \StructType\DocumentDetails
     */
    public function setShippingRule(\StructType\Field $shippingRule = null)
    {
        $this->ShippingRule = $shippingRule;
        return $this;
    }
    /**
     * Get UndershipThreshold value
     * @return \StructType\Field|null
     */
    public function getUndershipThreshold()
    {
        return $this->UndershipThreshold;
    }
    /**
     * Set UndershipThreshold value
     * @param \StructType\Field $undershipThreshold
     * @return \StructType\DocumentDetails
     */
    public function setUndershipThreshold(\StructType\Field $undershipThreshold = null)
    {
        $this->UndershipThreshold = $undershipThreshold;
        return $this;
    }
    /**
     * Get OvershipThreshold value
     * @return \StructType\Field|null
     */
    public function getOvershipThreshold()
    {
        return $this->OvershipThreshold;
    }
    /**
     * Set OvershipThreshold value
     * @param \StructType\Field $overshipThreshold
     * @return \StructType\DocumentDetails
     */
    public function setOvershipThreshold(\StructType\Field $overshipThreshold = null)
    {
        $this->OvershipThreshold = $overshipThreshold;
        return $this;
    }
    /**
     * Get Completed value
     * @return \StructType\Field|null
     */
    public function getCompleted()
    {
        return $this->Completed;
    }
    /**
     * Set Completed value
     * @param \StructType\Field $completed
     * @return \StructType\DocumentDetails
     */
    public function setCompleted(\StructType\Field $completed = null)
    {
        $this->Completed = $completed;
        return $this;
    }
    /**
     * Get MarkForPO value
     * @return \StructType\Field|null
     */
    public function getMarkForPO()
    {
        return $this->MarkForPO;
    }
    /**
     * Set MarkForPO value
     * @param \StructType\Field $markForPO
     * @return \StructType\DocumentDetails
     */
    public function setMarkForPO(\StructType\Field $markForPO = null)
    {
        $this->MarkForPO = $markForPO;
        return $this;
    }
    /**
     * Get POSource value
     * @return \StructType\Field|null
     */
    public function getPOSource()
    {
        return $this->POSource;
    }
    /**
     * Set POSource value
     * @param \StructType\Field $pOSource
     * @return \StructType\DocumentDetails
     */
    public function setPOSource(\StructType\Field $pOSource = null)
    {
        $this->POSource = $pOSource;
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * @return \StructType\Field|null
     */
    public function getLotSerialNbr()
    {
        return $this->LotSerialNbr;
    }
    /**
     * Set LotSerialNbr value
     * @param \StructType\Field $lotSerialNbr
     * @return \StructType\DocumentDetails
     */
    public function setLotSerialNbr(\StructType\Field $lotSerialNbr = null)
    {
        $this->LotSerialNbr = $lotSerialNbr;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return \StructType\Field|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param \StructType\Field $expirationDate
     * @return \StructType\DocumentDetails
     */
    public function setExpirationDate(\StructType\Field $expirationDate = null)
    {
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return \StructType\Field|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param \StructType\Field $reasonCode
     * @return \StructType\DocumentDetails
     */
    public function setReasonCode(\StructType\Field $reasonCode = null)
    {
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get SalespersonID value
     * @return \StructType\Field|null
     */
    public function getSalespersonID()
    {
        return $this->SalespersonID;
    }
    /**
     * Set SalespersonID value
     * @param \StructType\Field $salespersonID
     * @return \StructType\DocumentDetails
     */
    public function setSalespersonID(\StructType\Field $salespersonID = null)
    {
        $this->SalespersonID = $salespersonID;
        return $this;
    }
    /**
     * Get TaxCategory value
     * @return \StructType\Field|null
     */
    public function getTaxCategory()
    {
        return $this->TaxCategory;
    }
    /**
     * Set TaxCategory value
     * @param \StructType\Field $taxCategory
     * @return \StructType\DocumentDetails
     */
    public function setTaxCategory(\StructType\Field $taxCategory = null)
    {
        $this->TaxCategory = $taxCategory;
        return $this;
    }
    /**
     * Get EntityUsageType value
     * @return \StructType\Field|null
     */
    public function getEntityUsageType()
    {
        return $this->EntityUsageType;
    }
    /**
     * Set EntityUsageType value
     * @param \StructType\Field $entityUsageType
     * @return \StructType\DocumentDetails
     */
    public function setEntityUsageType(\StructType\Field $entityUsageType = null)
    {
        $this->EntityUsageType = $entityUsageType;
        return $this;
    }
    /**
     * Get Commissionable value
     * @return \StructType\Field|null
     */
    public function getCommissionable()
    {
        return $this->Commissionable;
    }
    /**
     * Set Commissionable value
     * @param \StructType\Field $commissionable
     * @return \StructType\DocumentDetails
     */
    public function setCommissionable(\StructType\Field $commissionable = null)
    {
        $this->Commissionable = $commissionable;
        return $this;
    }
    /**
     * Get AlternateID value
     * @return \StructType\Field|null
     */
    public function getAlternateID()
    {
        return $this->AlternateID;
    }
    /**
     * Set AlternateID value
     * @param \StructType\Field $alternateID
     * @return \StructType\DocumentDetails
     */
    public function setAlternateID(\StructType\Field $alternateID = null)
    {
        $this->AlternateID = $alternateID;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\Field|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\Field $account
     * @return \StructType\DocumentDetails
     */
    public function setAccount(\StructType\Field $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Subaccount value
     * @return \StructType\Field|null
     */
    public function getSubaccount()
    {
        return $this->Subaccount;
    }
    /**
     * Set Subaccount value
     * @param \StructType\Field $subaccount
     * @return \StructType\DocumentDetails
     */
    public function setSubaccount(\StructType\Field $subaccount = null)
    {
        $this->Subaccount = $subaccount;
        return $this;
    }
    /**
     * Get ProjectTask value
     * @return \StructType\Field|null
     */
    public function getProjectTask()
    {
        return $this->ProjectTask;
    }
    /**
     * Set ProjectTask value
     * @param \StructType\Field $projectTask
     * @return \StructType\DocumentDetails
     */
    public function setProjectTask(\StructType\Field $projectTask = null)
    {
        $this->ProjectTask = $projectTask;
        return $this;
    }
    /**
     * Get CostCode value
     * @return \StructType\Field|null
     */
    public function getCostCode()
    {
        return $this->CostCode;
    }
    /**
     * Set CostCode value
     * @param \StructType\Field $costCode
     * @return \StructType\DocumentDetails
     */
    public function setCostCode(\StructType\Field $costCode = null)
    {
        $this->CostCode = $costCode;
        return $this;
    }
    /**
     * Get UnitPriceForDR value
     * @return \StructType\Field|null
     */
    public function getUnitPriceForDR()
    {
        return $this->UnitPriceForDR;
    }
    /**
     * Set UnitPriceForDR value
     * @param \StructType\Field $unitPriceForDR
     * @return \StructType\DocumentDetails
     */
    public function setUnitPriceForDR(\StructType\Field $unitPriceForDR = null)
    {
        $this->UnitPriceForDR = $unitPriceForDR;
        return $this;
    }
    /**
     * Get DiscountPercentForDR value
     * @return \StructType\Field|null
     */
    public function getDiscountPercentForDR()
    {
        return $this->DiscountPercentForDR;
    }
    /**
     * Set DiscountPercentForDR value
     * @param \StructType\Field $discountPercentForDR
     * @return \StructType\DocumentDetails
     */
    public function setDiscountPercentForDR(\StructType\Field $discountPercentForDR = null)
    {
        $this->DiscountPercentForDR = $discountPercentForDR;
        return $this;
    }
    /**
     * Get ROTOrRUTDeductible value
     * @return \StructType\Field|null
     */
    public function getROTOrRUTDeductible()
    {
        return $this->ROTOrRUTDeductible;
    }
    /**
     * Set ROTOrRUTDeductible value
     * @param \StructType\Field $rOTOrRUTDeductible
     * @return \StructType\DocumentDetails
     */
    public function setROTOrRUTDeductible(\StructType\Field $rOTOrRUTDeductible = null)
    {
        $this->ROTOrRUTDeductible = $rOTOrRUTDeductible;
        return $this;
    }
    /**
     * Get ItemType value
     * @return \StructType\Field|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @param \StructType\Field $itemType
     * @return \StructType\DocumentDetails
     */
    public function setItemType(\StructType\Field $itemType = null)
    {
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get TypeOfWork value
     * @return \StructType\Field|null
     */
    public function getTypeOfWork()
    {
        return $this->TypeOfWork;
    }
    /**
     * Set TypeOfWork value
     * @param \StructType\Field $typeOfWork
     * @return \StructType\DocumentDetails
     */
    public function setTypeOfWork(\StructType\Field $typeOfWork = null)
    {
        $this->TypeOfWork = $typeOfWork;
        return $this;
    }
    /**
     * Get DeductibleAmount value
     * @return \StructType\Field|null
     */
    public function getDeductibleAmount()
    {
        return $this->DeductibleAmount;
    }
    /**
     * Set DeductibleAmount value
     * @param \StructType\Field $deductibleAmount
     * @return \StructType\DocumentDetails
     */
    public function setDeductibleAmount(\StructType\Field $deductibleAmount = null)
    {
        $this->DeductibleAmount = $deductibleAmount;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\DocumentDetails
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get Availability value
     * @return \StructType\Field|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param \StructType\Field $availability
     * @return \StructType\DocumentDetails
     */
    public function setAvailability(\StructType\Field $availability = null)
    {
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\DocumentDetailsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\DocumentDetailsServiceCommands $serviceCommands
     * @return \StructType\DocumentDetails
     */
    public function setServiceCommands(\StructType\DocumentDetailsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
