<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Allocations StructType
 * @subpackage Structs
 */
class Allocations extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The AllocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AllocationID;
    /**
     * The ParentAllocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ParentAllocationID;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryID;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Subitem;
    /**
     * The ShipOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipOn;
    /**
     * The Allocated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Allocated;
    /**
     * The AllocWarehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AllocWarehouse;
    /**
     * The Completed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Completed;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Location;
    /**
     * The LotSerialNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LotSerialNbr;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Quantity;
    /**
     * The QtyOnShipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyOnShipments;
    /**
     * The QtyReceived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyReceived;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExpirationDate;
    /**
     * The MarkForPO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MarkForPO;
    /**
     * The RelatedDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RelatedDocument;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AllocationsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Allocations
     * @uses Allocations::setDisplayName()
     * @uses Allocations::setAllocationID()
     * @uses Allocations::setParentAllocationID()
     * @uses Allocations::setInventoryID()
     * @uses Allocations::setSubitem()
     * @uses Allocations::setShipOn()
     * @uses Allocations::setAllocated()
     * @uses Allocations::setAllocWarehouse()
     * @uses Allocations::setCompleted()
     * @uses Allocations::setLocation()
     * @uses Allocations::setLotSerialNbr()
     * @uses Allocations::setQuantity()
     * @uses Allocations::setQtyOnShipments()
     * @uses Allocations::setQtyReceived()
     * @uses Allocations::setUOM()
     * @uses Allocations::setExpirationDate()
     * @uses Allocations::setMarkForPO()
     * @uses Allocations::setRelatedDocument()
     * @uses Allocations::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $allocationID
     * @param \StructType\Field $parentAllocationID
     * @param \StructType\Field $inventoryID
     * @param \StructType\Field $subitem
     * @param \StructType\Field $shipOn
     * @param \StructType\Field $allocated
     * @param \StructType\Field $allocWarehouse
     * @param \StructType\Field $completed
     * @param \StructType\Field $location
     * @param \StructType\Field $lotSerialNbr
     * @param \StructType\Field $quantity
     * @param \StructType\Field $qtyOnShipments
     * @param \StructType\Field $qtyReceived
     * @param \StructType\Field $uOM
     * @param \StructType\Field $expirationDate
     * @param \StructType\Field $markForPO
     * @param \StructType\Field $relatedDocument
     * @param \StructType\AllocationsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $allocationID = null, \StructType\Field $parentAllocationID = null, \StructType\Field $inventoryID = null, \StructType\Field $subitem = null, \StructType\Field $shipOn = null, \StructType\Field $allocated = null, \StructType\Field $allocWarehouse = null, \StructType\Field $completed = null, \StructType\Field $location = null, \StructType\Field $lotSerialNbr = null, \StructType\Field $quantity = null, \StructType\Field $qtyOnShipments = null, \StructType\Field $qtyReceived = null, \StructType\Field $uOM = null, \StructType\Field $expirationDate = null, \StructType\Field $markForPO = null, \StructType\Field $relatedDocument = null, \StructType\AllocationsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setAllocationID($allocationID)
            ->setParentAllocationID($parentAllocationID)
            ->setInventoryID($inventoryID)
            ->setSubitem($subitem)
            ->setShipOn($shipOn)
            ->setAllocated($allocated)
            ->setAllocWarehouse($allocWarehouse)
            ->setCompleted($completed)
            ->setLocation($location)
            ->setLotSerialNbr($lotSerialNbr)
            ->setQuantity($quantity)
            ->setQtyOnShipments($qtyOnShipments)
            ->setQtyReceived($qtyReceived)
            ->setUOM($uOM)
            ->setExpirationDate($expirationDate)
            ->setMarkForPO($markForPO)
            ->setRelatedDocument($relatedDocument)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Allocations
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get AllocationID value
     * @return \StructType\Field|null
     */
    public function getAllocationID()
    {
        return $this->AllocationID;
    }
    /**
     * Set AllocationID value
     * @param \StructType\Field $allocationID
     * @return \StructType\Allocations
     */
    public function setAllocationID(\StructType\Field $allocationID = null)
    {
        $this->AllocationID = $allocationID;
        return $this;
    }
    /**
     * Get ParentAllocationID value
     * @return \StructType\Field|null
     */
    public function getParentAllocationID()
    {
        return $this->ParentAllocationID;
    }
    /**
     * Set ParentAllocationID value
     * @param \StructType\Field $parentAllocationID
     * @return \StructType\Allocations
     */
    public function setParentAllocationID(\StructType\Field $parentAllocationID = null)
    {
        $this->ParentAllocationID = $parentAllocationID;
        return $this;
    }
    /**
     * Get InventoryID value
     * @return \StructType\Field|null
     */
    public function getInventoryID()
    {
        return $this->InventoryID;
    }
    /**
     * Set InventoryID value
     * @param \StructType\Field $inventoryID
     * @return \StructType\Allocations
     */
    public function setInventoryID(\StructType\Field $inventoryID = null)
    {
        $this->InventoryID = $inventoryID;
        return $this;
    }
    /**
     * Get Subitem value
     * @return \StructType\Field|null
     */
    public function getSubitem()
    {
        return $this->Subitem;
    }
    /**
     * Set Subitem value
     * @param \StructType\Field $subitem
     * @return \StructType\Allocations
     */
    public function setSubitem(\StructType\Field $subitem = null)
    {
        $this->Subitem = $subitem;
        return $this;
    }
    /**
     * Get ShipOn value
     * @return \StructType\Field|null
     */
    public function getShipOn()
    {
        return $this->ShipOn;
    }
    /**
     * Set ShipOn value
     * @param \StructType\Field $shipOn
     * @return \StructType\Allocations
     */
    public function setShipOn(\StructType\Field $shipOn = null)
    {
        $this->ShipOn = $shipOn;
        return $this;
    }
    /**
     * Get Allocated value
     * @return \StructType\Field|null
     */
    public function getAllocated()
    {
        return $this->Allocated;
    }
    /**
     * Set Allocated value
     * @param \StructType\Field $allocated
     * @return \StructType\Allocations
     */
    public function setAllocated(\StructType\Field $allocated = null)
    {
        $this->Allocated = $allocated;
        return $this;
    }
    /**
     * Get AllocWarehouse value
     * @return \StructType\Field|null
     */
    public function getAllocWarehouse()
    {
        return $this->AllocWarehouse;
    }
    /**
     * Set AllocWarehouse value
     * @param \StructType\Field $allocWarehouse
     * @return \StructType\Allocations
     */
    public function setAllocWarehouse(\StructType\Field $allocWarehouse = null)
    {
        $this->AllocWarehouse = $allocWarehouse;
        return $this;
    }
    /**
     * Get Completed value
     * @return \StructType\Field|null
     */
    public function getCompleted()
    {
        return $this->Completed;
    }
    /**
     * Set Completed value
     * @param \StructType\Field $completed
     * @return \StructType\Allocations
     */
    public function setCompleted(\StructType\Field $completed = null)
    {
        $this->Completed = $completed;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Field|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Field $location
     * @return \StructType\Allocations
     */
    public function setLocation(\StructType\Field $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * @return \StructType\Field|null
     */
    public function getLotSerialNbr()
    {
        return $this->LotSerialNbr;
    }
    /**
     * Set LotSerialNbr value
     * @param \StructType\Field $lotSerialNbr
     * @return \StructType\Allocations
     */
    public function setLotSerialNbr(\StructType\Field $lotSerialNbr = null)
    {
        $this->LotSerialNbr = $lotSerialNbr;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \StructType\Field|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \StructType\Field $quantity
     * @return \StructType\Allocations
     */
    public function setQuantity(\StructType\Field $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QtyOnShipments value
     * @return \StructType\Field|null
     */
    public function getQtyOnShipments()
    {
        return $this->QtyOnShipments;
    }
    /**
     * Set QtyOnShipments value
     * @param \StructType\Field $qtyOnShipments
     * @return \StructType\Allocations
     */
    public function setQtyOnShipments(\StructType\Field $qtyOnShipments = null)
    {
        $this->QtyOnShipments = $qtyOnShipments;
        return $this;
    }
    /**
     * Get QtyReceived value
     * @return \StructType\Field|null
     */
    public function getQtyReceived()
    {
        return $this->QtyReceived;
    }
    /**
     * Set QtyReceived value
     * @param \StructType\Field $qtyReceived
     * @return \StructType\Allocations
     */
    public function setQtyReceived(\StructType\Field $qtyReceived = null)
    {
        $this->QtyReceived = $qtyReceived;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\Allocations
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return \StructType\Field|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param \StructType\Field $expirationDate
     * @return \StructType\Allocations
     */
    public function setExpirationDate(\StructType\Field $expirationDate = null)
    {
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get MarkForPO value
     * @return \StructType\Field|null
     */
    public function getMarkForPO()
    {
        return $this->MarkForPO;
    }
    /**
     * Set MarkForPO value
     * @param \StructType\Field $markForPO
     * @return \StructType\Allocations
     */
    public function setMarkForPO(\StructType\Field $markForPO = null)
    {
        $this->MarkForPO = $markForPO;
        return $this;
    }
    /**
     * Get RelatedDocument value
     * @return \StructType\Field|null
     */
    public function getRelatedDocument()
    {
        return $this->RelatedDocument;
    }
    /**
     * Set RelatedDocument value
     * @param \StructType\Field $relatedDocument
     * @return \StructType\Allocations
     */
    public function setRelatedDocument(\StructType\Field $relatedDocument = null)
    {
        $this->RelatedDocument = $relatedDocument;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\AllocationsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\AllocationsServiceCommands $serviceCommands
     * @return \StructType\Allocations
     */
    public function setServiceCommands(\StructType\AllocationsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Allocations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
