<?php

namespace EnumType;

/**
 * This class stands for SchemaMode EnumType
 * @subpackage Enumerations
 */
class SchemaMode
{
    /**
     * Constant for value 'Basic'
     * @return string 'Basic'
     */
    const VALUE_BASIC = 'Basic';
    /**
     * Constant for value 'Detailed'
     * @return string 'Detailed'
     */
    const VALUE_DETAILED = 'Detailed';
    /**
     * Constant for value 'DetailedWithHidden'
     * @return string 'DetailedWithHidden'
     */
    const VALUE_DETAILED_WITH_HIDDEN = 'DetailedWithHidden';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BASIC
     * @uses self::VALUE_DETAILED
     * @uses self::VALUE_DETAILED_WITH_HIDDEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASIC,
            self::VALUE_DETAILED,
            self::VALUE_DETAILED_WITH_HIDDEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
