<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarrantyCollection StructType
 * @subpackage Structs
 */
class WarrantyCollection extends AbstractStructBase
{
    /**
     * The Months
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Months;
    /**
     * The Km
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Km;
    /**
     * Constructor method for WarrantyCollection
     * @uses WarrantyCollection::setMonths()
     * @uses WarrantyCollection::setKm()
     * @param int $months
     * @param int $km
     */
    public function __construct($months = null, $km = null)
    {
        $this
            ->setMonths($months)
            ->setKm($km);
    }
    /**
     * Get Months value
     * @return int|null
     */
    public function getMonths()
    {
        return $this->Months;
    }
    /**
     * Set Months value
     * @param int $months
     * @return \StructType\WarrantyCollection
     */
    public function setMonths($months = null)
    {
        // validation for constraint: int
        if (!is_null($months) && !is_numeric($months)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($months)), __LINE__);
        }
        $this->Months = $months;
        return $this;
    }
    /**
     * Get Km value
     * @return int|null
     */
    public function getKm()
    {
        return $this->Km;
    }
    /**
     * Set Km value
     * @param int $km
     * @return \StructType\WarrantyCollection
     */
    public function setKm($km = null)
    {
        // validation for constraint: int
        if (!is_null($km) && !is_numeric($km)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($km)), __LINE__);
        }
        $this->Km = $km;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WarrantyCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
