<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StateCollection StructType
 * @subpackage Structs
 */
class StateCollection extends AbstractStructBase
{
    /**
     * The Sold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Sold;
    /**
     * The SoldDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoldDate;
    /**
     * The Deleted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Deleted;
    /**
     * The DeletionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeletionDate;
    /**
     * The Reserved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Reserved;
    /**
     * The ReservedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservedDate;
    /**
     * Constructor method for StateCollection
     * @uses StateCollection::setSold()
     * @uses StateCollection::setSoldDate()
     * @uses StateCollection::setDeleted()
     * @uses StateCollection::setDeletionDate()
     * @uses StateCollection::setReserved()
     * @uses StateCollection::setReservedDate()
     * @param bool $sold
     * @param string $soldDate
     * @param bool $deleted
     * @param string $deletionDate
     * @param bool $reserved
     * @param string $reservedDate
     */
    public function __construct($sold = null, $soldDate = null, $deleted = null, $deletionDate = null, $reserved = null, $reservedDate = null)
    {
        $this
            ->setSold($sold)
            ->setSoldDate($soldDate)
            ->setDeleted($deleted)
            ->setDeletionDate($deletionDate)
            ->setReserved($reserved)
            ->setReservedDate($reservedDate);
    }
    /**
     * Get Sold value
     * @return bool|null
     */
    public function getSold()
    {
        return $this->Sold;
    }
    /**
     * Set Sold value
     * @param bool $sold
     * @return \StructType\StateCollection
     */
    public function setSold($sold = null)
    {
        $this->Sold = $sold;
        return $this;
    }
    /**
     * Get SoldDate value
     * @return string|null
     */
    public function getSoldDate()
    {
        return $this->SoldDate;
    }
    /**
     * Set SoldDate value
     * @param string $soldDate
     * @return \StructType\StateCollection
     */
    public function setSoldDate($soldDate = null)
    {
        // validation for constraint: string
        if (!is_null($soldDate) && !is_string($soldDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($soldDate)), __LINE__);
        }
        $this->SoldDate = $soldDate;
        return $this;
    }
    /**
     * Get Deleted value
     * @return bool|null
     */
    public function getDeleted()
    {
        return $this->Deleted;
    }
    /**
     * Set Deleted value
     * @param bool $deleted
     * @return \StructType\StateCollection
     */
    public function setDeleted($deleted = null)
    {
        $this->Deleted = $deleted;
        return $this;
    }
    /**
     * Get DeletionDate value
     * @return string|null
     */
    public function getDeletionDate()
    {
        return $this->DeletionDate;
    }
    /**
     * Set DeletionDate value
     * @param string $deletionDate
     * @return \StructType\StateCollection
     */
    public function setDeletionDate($deletionDate = null)
    {
        // validation for constraint: string
        if (!is_null($deletionDate) && !is_string($deletionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deletionDate)), __LINE__);
        }
        $this->DeletionDate = $deletionDate;
        return $this;
    }
    /**
     * Get Reserved value
     * @return bool|null
     */
    public function getReserved()
    {
        return $this->Reserved;
    }
    /**
     * Set Reserved value
     * @param bool $reserved
     * @return \StructType\StateCollection
     */
    public function setReserved($reserved = null)
    {
        $this->Reserved = $reserved;
        return $this;
    }
    /**
     * Get ReservedDate value
     * @return string|null
     */
    public function getReservedDate()
    {
        return $this->ReservedDate;
    }
    /**
     * Set ReservedDate value
     * @param string $reservedDate
     * @return \StructType\StateCollection
     */
    public function setReservedDate($reservedDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservedDate) && !is_string($reservedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservedDate)), __LINE__);
        }
        $this->ReservedDate = $reservedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StateCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
