<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PicturesCollection StructType
 * @subpackage Structs
 */
class PicturesCollection extends AbstractStructBase
{
    /**
     * The Picture
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PictureTypeCollection[]
     */
    public $Picture;
    /**
     * Constructor method for PicturesCollection
     * @uses PicturesCollection::setPicture()
     * @param \StructType\PictureTypeCollection[] $picture
     */
    public function __construct(array $picture = array())
    {
        $this
            ->setPicture($picture);
    }
    /**
     * Get Picture value
     * @return \StructType\PictureTypeCollection[]|null
     */
    public function getPicture()
    {
        return $this->Picture;
    }
    /**
     * Set Picture value
     * @throws \InvalidArgumentException
     * @param \StructType\PictureTypeCollection[] $picture
     * @return \StructType\PicturesCollection
     */
    public function setPicture(array $picture = array())
    {
        foreach ($picture as $picturesCollectionPictureItem) {
            // validation for constraint: itemType
            if (!$picturesCollectionPictureItem instanceof \StructType\PictureTypeCollection) {
                throw new \InvalidArgumentException(sprintf('The Picture property can only contain items of \StructType\PictureTypeCollection, "%s" given', is_object($picturesCollectionPictureItem) ? get_class($picturesCollectionPictureItem) : gettype($picturesCollectionPictureItem)), __LINE__);
            }
        }
        $this->Picture = $picture;
        return $this;
    }
    /**
     * Add item to Picture value
     * @throws \InvalidArgumentException
     * @param \StructType\PictureTypeCollection $item
     * @return \StructType\PicturesCollection
     */
    public function addToPicture(\StructType\PictureTypeCollection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PictureTypeCollection) {
            throw new \InvalidArgumentException(sprintf('The Picture property can only contain items of \StructType\PictureTypeCollection, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Picture[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PicturesCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
