<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OAccsListCollection StructType
 * @subpackage Structs
 */
class OAccsListCollection extends AbstractStructBase
{
    /**
     * The OAccs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OAccs;
    /**
     * Constructor method for OAccsListCollection
     * @uses OAccsListCollection::setOAccs()
     * @param string[] $oAccs
     */
    public function __construct(array $oAccs = array())
    {
        $this
            ->setOAccs($oAccs);
    }
    /**
     * Get OAccs value
     * @return string[]|null
     */
    public function getOAccs()
    {
        return $this->OAccs;
    }
    /**
     * Set OAccs value
     * @throws \InvalidArgumentException
     * @param string[] $oAccs
     * @return \StructType\OAccsListCollection
     */
    public function setOAccs(array $oAccs = array())
    {
        foreach ($oAccs as $oAccsListCollectionOAccsItem) {
            // validation for constraint: itemType
            if (!is_string($oAccsListCollectionOAccsItem)) {
                throw new \InvalidArgumentException(sprintf('The OAccs property can only contain items of string, "%s" given', is_object($oAccsListCollectionOAccsItem) ? get_class($oAccsListCollectionOAccsItem) : gettype($oAccsListCollectionOAccsItem)), __LINE__);
            }
        }
        $this->OAccs = $oAccs;
        return $this;
    }
    /**
     * Add item to OAccs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OAccsListCollection
     */
    public function addToOAccs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OAccs property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OAccs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OAccsListCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
