<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeasingCollection StructType
 * @subpackage Structs
 */
class LeasingCollection extends AbstractStructBase
{
    /**
     * The Bank
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Bank;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Duration;
    /**
     * The Instalment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Instalment;
    /**
     * The DecBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DecBalance;
    /**
     * The Spayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Spayment;
    /**
     * The KmPerYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmPerYear;
    /**
     * Constructor method for LeasingCollection
     * @uses LeasingCollection::setBank()
     * @uses LeasingCollection::setDuration()
     * @uses LeasingCollection::setInstalment()
     * @uses LeasingCollection::setDecBalance()
     * @uses LeasingCollection::setSpayment()
     * @uses LeasingCollection::setKmPerYear()
     * @param string $bank
     * @param int $duration
     * @param float $instalment
     * @param float $decBalance
     * @param float $spayment
     * @param int $kmPerYear
     */
    public function __construct($bank = null, $duration = null, $instalment = null, $decBalance = null, $spayment = null, $kmPerYear = null)
    {
        $this
            ->setBank($bank)
            ->setDuration($duration)
            ->setInstalment($instalment)
            ->setDecBalance($decBalance)
            ->setSpayment($spayment)
            ->setKmPerYear($kmPerYear);
    }
    /**
     * Get Bank value
     * @return string
     */
    public function getBank()
    {
        return $this->Bank;
    }
    /**
     * Set Bank value
     * @param string $bank
     * @return \StructType\LeasingCollection
     */
    public function setBank($bank = null)
    {
        // validation for constraint: string
        if (!is_null($bank) && !is_string($bank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bank)), __LINE__);
        }
        $this->Bank = $bank;
        return $this;
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\LeasingCollection
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Instalment value
     * @return float
     */
    public function getInstalment()
    {
        return $this->Instalment;
    }
    /**
     * Set Instalment value
     * @param float $instalment
     * @return \StructType\LeasingCollection
     */
    public function setInstalment($instalment = null)
    {
        $this->Instalment = $instalment;
        return $this;
    }
    /**
     * Get DecBalance value
     * @return float
     */
    public function getDecBalance()
    {
        return $this->DecBalance;
    }
    /**
     * Set DecBalance value
     * @param float $decBalance
     * @return \StructType\LeasingCollection
     */
    public function setDecBalance($decBalance = null)
    {
        $this->DecBalance = $decBalance;
        return $this;
    }
    /**
     * Get Spayment value
     * @return float
     */
    public function getSpayment()
    {
        return $this->Spayment;
    }
    /**
     * Set Spayment value
     * @param float $spayment
     * @return \StructType\LeasingCollection
     */
    public function setSpayment($spayment = null)
    {
        $this->Spayment = $spayment;
        return $this;
    }
    /**
     * Get KmPerYear value
     * @return int
     */
    public function getKmPerYear()
    {
        return $this->KmPerYear;
    }
    /**
     * Set KmPerYear value
     * @param int $kmPerYear
     * @return \StructType\LeasingCollection
     */
    public function setKmPerYear($kmPerYear = null)
    {
        // validation for constraint: int
        if (!is_null($kmPerYear) && !is_numeric($kmPerYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmPerYear)), __LINE__);
        }
        $this->KmPerYear = $kmPerYear;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LeasingCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
