<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InspectionCollection StructType
 * @subpackage Structs
 */
class InspectionCollection extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The New
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $New;
    /**
     * Constructor method for InspectionCollection
     * @uses InspectionCollection::setDate()
     * @uses InspectionCollection::setNew()
     * @param string $date
     * @param bool $new
     */
    public function __construct($date = null, $new = null)
    {
        $this
            ->setDate($date)
            ->setNew($new);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\InspectionCollection
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get New value
     * @return bool|null
     */
    public function getNew()
    {
        return $this->New;
    }
    /**
     * Set New value
     * @param bool $new
     * @return \StructType\InspectionCollection
     */
    public function setNew($new = null)
    {
        $this->New = $new;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InspectionCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
