<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostsCollection StructType
 * @subpackage Structs
 */
class CostsCollection extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The Descr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Descr;
    /**
     * The DescrId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DescrId;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Note;
    /**
     * Constructor method for CostsCollection
     * @uses CostsCollection::setDate()
     * @uses CostsCollection::setDescr()
     * @uses CostsCollection::setDescrId()
     * @uses CostsCollection::setPrice()
     * @uses CostsCollection::setNote()
     * @param string $date
     * @param string $descr
     * @param int $descrId
     * @param float $price
     * @param string $note
     */
    public function __construct($date = null, $descr = null, $descrId = null, $price = null, $note = null)
    {
        $this
            ->setDate($date)
            ->setDescr($descr)
            ->setDescrId($descrId)
            ->setPrice($price)
            ->setNote($note);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\CostsCollection
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Descr value
     * @return string
     */
    public function getDescr()
    {
        return $this->Descr;
    }
    /**
     * Set Descr value
     * @param string $descr
     * @return \StructType\CostsCollection
     */
    public function setDescr($descr = null)
    {
        // validation for constraint: string
        if (!is_null($descr) && !is_string($descr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descr)), __LINE__);
        }
        $this->Descr = $descr;
        return $this;
    }
    /**
     * Get DescrId value
     * @return int
     */
    public function getDescrId()
    {
        return $this->DescrId;
    }
    /**
     * Set DescrId value
     * @param int $descrId
     * @return \StructType\CostsCollection
     */
    public function setDescrId($descrId = null)
    {
        // validation for constraint: int
        if (!is_null($descrId) && !is_numeric($descrId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($descrId)), __LINE__);
        }
        $this->DescrId = $descrId;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\CostsCollection
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Note value
     * @return string
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \StructType\CostsCollection
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CostsCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
