<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Do ServiceType
 */
$do = new \ServiceType\_Do($options);
/**
 * Sample call for doVehicleFilterView operation/method
 */
if ($do->doVehicleFilterView(new \StructType\FilterCollection(), new \StructType\FieldsCollection(), $Start, $Limit, $OrderField, $OrderType) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Sample call for doVehicleFieldGroupView operation/method
 */
if ($do->doVehicleFieldGroupView($FieldName, new \StructType\FilterCollection()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getAvailableLanguages operation/method
 */
if ($get->getAvailableLanguages($BaseLangKey) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLabelTranslations operation/method
 */
if ($get->getLabelTranslations($BaseLangKey) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getValueTranslations operation/method
 */
if ($get->getValueTranslations($Label, $BaseLangKey) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAvailableValueLabels operation/method
 */
if ($get->getAvailableValueLabels($BaseLangKey) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
