<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeightCollection StructType
 * @subpackage Structs
 */
class WeightCollection extends AbstractStructBase
{
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Total;
    /**
     * The Empty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Empty;
    /**
     * The Payload
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Payload;
    /**
     * The Train
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Train;
    /**
     * The Lifting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Lifting;
    /**
     * The Coc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Coc;
    /**
     * Constructor method for WeightCollection
     * @uses WeightCollection::setTotal()
     * @uses WeightCollection::setEmpty()
     * @uses WeightCollection::setPayload()
     * @uses WeightCollection::setTrain()
     * @uses WeightCollection::setLifting()
     * @uses WeightCollection::setCoc()
     * @param int $total
     * @param int $empty
     * @param int $payload
     * @param int $train
     * @param int $lifting
     * @param int $coc
     */
    public function __construct($total = null, $empty = null, $payload = null, $train = null, $lifting = null, $coc = null)
    {
        $this
            ->setTotal($total)
            ->setEmpty($empty)
            ->setPayload($payload)
            ->setTrain($train)
            ->setLifting($lifting)
            ->setCoc($coc);
    }
    /**
     * Get Total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \StructType\WeightCollection
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Empty value
     * @return int|null
     */
    public function getEmpty()
    {
        return $this->Empty;
    }
    /**
     * Set Empty value
     * @param int $empty
     * @return \StructType\WeightCollection
     */
    public function setEmpty($empty = null)
    {
        // validation for constraint: int
        if (!is_null($empty) && !is_numeric($empty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($empty)), __LINE__);
        }
        $this->Empty = $empty;
        return $this;
    }
    /**
     * Get Payload value
     * @return int|null
     */
    public function getPayload()
    {
        return $this->Payload;
    }
    /**
     * Set Payload value
     * @param int $payload
     * @return \StructType\WeightCollection
     */
    public function setPayload($payload = null)
    {
        // validation for constraint: int
        if (!is_null($payload) && !is_numeric($payload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payload)), __LINE__);
        }
        $this->Payload = $payload;
        return $this;
    }
    /**
     * Get Train value
     * @return int|null
     */
    public function getTrain()
    {
        return $this->Train;
    }
    /**
     * Set Train value
     * @param int $train
     * @return \StructType\WeightCollection
     */
    public function setTrain($train = null)
    {
        // validation for constraint: int
        if (!is_null($train) && !is_numeric($train)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($train)), __LINE__);
        }
        $this->Train = $train;
        return $this;
    }
    /**
     * Get Lifting value
     * @return int|null
     */
    public function getLifting()
    {
        return $this->Lifting;
    }
    /**
     * Set Lifting value
     * @param int $lifting
     * @return \StructType\WeightCollection
     */
    public function setLifting($lifting = null)
    {
        // validation for constraint: int
        if (!is_null($lifting) && !is_numeric($lifting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lifting)), __LINE__);
        }
        $this->Lifting = $lifting;
        return $this;
    }
    /**
     * Get Coc value
     * @return int|null
     */
    public function getCoc()
    {
        return $this->Coc;
    }
    /**
     * Set Coc value
     * @param int $coc
     * @return \StructType\WeightCollection
     */
    public function setCoc($coc = null)
    {
        // validation for constraint: int
        if (!is_null($coc) && !is_numeric($coc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($coc)), __LINE__);
        }
        $this->Coc = $coc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WeightCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
