<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehicle StructType
 * @subpackage Structs
 */
class Vehicle extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Overall Uniq Vehicle ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - documentation: Overall Uniq Customer ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Customer;
    /**
     * The Area
     * Meta informations extracted from the WSDL
     * - documentation: Vehicle Area
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Area;
    /**
     * The CustomerVehicleId
     * Meta informations extracted from the WSDL
     * - documentation: ID for this vehicle given by the Customer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerVehicleId;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - documentation: Creation date of this vehicle
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDate;
    /**
     * The LastChange
     * Meta informations extracted from the WSDL
     * - documentation: Date of the last change of this vehicle
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastChange;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StateCollection
     */
    public $State;
    /**
     * The Manufacturer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ManufacturerCollection
     */
    public $Manufacturer;
    /**
     * The Model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Model;
    /**
     * The Smodel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Smodel;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Category;
    /**
     * The SubCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SubCategory;
    /**
     * The FullCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FullCategory;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Type;
    /**
     * The SpecialState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SpecialStateCollection
     */
    public $SpecialState;
    /**
     * The Byear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Byear;
    /**
     * The Myear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Myear;
    /**
     * The Hsn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Hsn;
    /**
     * The Tsn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tsn;
    /**
     * The LicenseNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicenseNo;
    /**
     * The Schwacke
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schwacke;
    /**
     * The Jato
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Jato;
    /**
     * The Emissionstd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Emissionstd;
    /**
     * The Co2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Co2;
    /**
     * The Co2Other
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Co2Other;
    /**
     * The FuelConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FuelConsumptionCollection
     */
    public $FuelConsumption;
    /**
     * The FuelConsumptionOther
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FuelConsumptionCollection
     */
    public $FuelConsumptionOther;
    /**
     * The EPowerConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FuelConsumptionCollection
     */
    public $EPowerConsumption;
    /**
     * The Pcasco
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Pcasco;
    /**
     * The Ccasco
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Ccasco;
    /**
     * The Liability
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Liability;
    /**
     * The GeneralInspection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InspectionCollection
     */
    public $GeneralInspection;
    /**
     * The EmissionTest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InspectionCollection
     */
    public $EmissionTest;
    /**
     * The RegDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegDate;
    /**
     * The SuspensionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SuspensionDate;
    /**
     * The InspectionDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InspectionDatesCollection
     */
    public $InspectionDates;
    /**
     * The Km
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Km;
    /**
     * The Condition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Condition;
    /**
     * The DeliveryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DeliveryDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DeliveryDays;
    /**
     * The Fuel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Fuel;
    /**
     * The FuelOther
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $FuelOther;
    /**
     * The Ccm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Ccm;
    /**
     * The Cylinders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Cylinders;
    /**
     * The Gearbox
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Gearbox;
    /**
     * The Gearcount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Gearcount;
    /**
     * The Drive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Drive;
    /**
     * The Power
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Power;
    /**
     * The Doors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Doors;
    /**
     * The Seats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Seats;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WeightCollection
     */
    public $Weight;
    /**
     * The Dimensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DimensionsCollection
     */
    public $Dimensions;
    /**
     * The UV
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UVCollection
     */
    public $UV;
    /**
     * The Freetext
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FreetextCollection
     */
    public $Freetext;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceCollection
     */
    public $Price;
    /**
     * The Costs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCosts
     */
    public $Costs;
    /**
     * The Financing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FinancingCollection
     */
    public $Financing;
    /**
     * The Leasing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LeasingCollection
     */
    public $Leasing;
    /**
     * The CCFinancing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CCFinancingCollection
     */
    public $CCFinancing;
    /**
     * The Color
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ColorCollection
     */
    public $Color;
    /**
     * The Pictures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PicturesCollection
     */
    public $Pictures;
    /**
     * The KeyNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyNo;
    /**
     * The VIN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VIN;
    /**
     * The RegDocNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegDocNo;
    /**
     * The RegDocPlace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegDocPlace;
    /**
     * The RoadNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoadNo;
    /**
     * The BookNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookNo;
    /**
     * The RadioCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RadioCode;
    /**
     * The KeyCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $KeyCount;
    /**
     * The Site
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Site;
    /**
     * The ServiceBook
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ServiceBook;
    /**
     * The CheckDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckDate;
    /**
     * The Preowners
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Preowners;
    /**
     * The UCWarrranty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $UCWarrranty;
    /**
     * The Warranty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarrantyCollection
     */
    public $Warranty;
    /**
     * The DekraSeal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DekraSeal;
    /**
     * The QualitySeal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $QualitySeal;
    /**
     * The ListInHpm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ListInHpm;
    /**
     * The ListInPrint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ListInPrint;
    /**
     * The AccsList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccsListCollection
     */
    public $AccsList;
    /**
     * The OAccsList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OAccsListCollection
     */
    public $OAccsList;
    /**
     * The NonSmoker
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NonSmoker;
    /**
     * The FullServiceHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $FullServiceHistory;
    /**
     * The FreeOfAccident
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $FreeOfAccident;
    /**
     * The Markets
     * Meta informations extracted from the WSDL
     * - documentation: The active Markets inclusiv all Market Options for this Vehicle
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MarketsCollection
     */
    public $Markets;
    /**
     * The EmissionClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $EmissionClass;
    /**
     * The EmissionBadge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EmissionBadge;
    /**
     * The EfficiencyClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EfficiencyClass;
    /**
     * The EnergyCosts20TKm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EnergyCosts20TKmCollection
     */
    public $EnergyCosts20TKm;
    /**
     * The MotorVehicleTaxPerYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MotorVehicleTaxPerYear;
    /**
     * Constructor method for Vehicle
     * @uses Vehicle::setId()
     * @uses Vehicle::setCustomer()
     * @uses Vehicle::setArea()
     * @uses Vehicle::setCustomerVehicleId()
     * @uses Vehicle::setCreationDate()
     * @uses Vehicle::setLastChange()
     * @uses Vehicle::setState()
     * @uses Vehicle::setManufacturer()
     * @uses Vehicle::setModel()
     * @uses Vehicle::setSmodel()
     * @uses Vehicle::setCategory()
     * @uses Vehicle::setSubCategory()
     * @uses Vehicle::setFullCategory()
     * @uses Vehicle::setType()
     * @uses Vehicle::setSpecialState()
     * @uses Vehicle::setByear()
     * @uses Vehicle::setMyear()
     * @uses Vehicle::setHsn()
     * @uses Vehicle::setTsn()
     * @uses Vehicle::setLicenseNo()
     * @uses Vehicle::setSchwacke()
     * @uses Vehicle::setJato()
     * @uses Vehicle::setEmissionstd()
     * @uses Vehicle::setCo2()
     * @uses Vehicle::setCo2Other()
     * @uses Vehicle::setFuelConsumption()
     * @uses Vehicle::setFuelConsumptionOther()
     * @uses Vehicle::setEPowerConsumption()
     * @uses Vehicle::setPcasco()
     * @uses Vehicle::setCcasco()
     * @uses Vehicle::setLiability()
     * @uses Vehicle::setGeneralInspection()
     * @uses Vehicle::setEmissionTest()
     * @uses Vehicle::setRegDate()
     * @uses Vehicle::setSuspensionDate()
     * @uses Vehicle::setInspectionDates()
     * @uses Vehicle::setKm()
     * @uses Vehicle::setCondition()
     * @uses Vehicle::setDeliveryDate()
     * @uses Vehicle::setDeliveryDays()
     * @uses Vehicle::setFuel()
     * @uses Vehicle::setFuelOther()
     * @uses Vehicle::setCcm()
     * @uses Vehicle::setCylinders()
     * @uses Vehicle::setGearbox()
     * @uses Vehicle::setGearcount()
     * @uses Vehicle::setDrive()
     * @uses Vehicle::setPower()
     * @uses Vehicle::setDoors()
     * @uses Vehicle::setSeats()
     * @uses Vehicle::setWeight()
     * @uses Vehicle::setDimensions()
     * @uses Vehicle::setUV()
     * @uses Vehicle::setFreetext()
     * @uses Vehicle::setPrice()
     * @uses Vehicle::setCosts()
     * @uses Vehicle::setFinancing()
     * @uses Vehicle::setLeasing()
     * @uses Vehicle::setCCFinancing()
     * @uses Vehicle::setColor()
     * @uses Vehicle::setPictures()
     * @uses Vehicle::setKeyNo()
     * @uses Vehicle::setVIN()
     * @uses Vehicle::setRegDocNo()
     * @uses Vehicle::setRegDocPlace()
     * @uses Vehicle::setRoadNo()
     * @uses Vehicle::setBookNo()
     * @uses Vehicle::setRadioCode()
     * @uses Vehicle::setKeyCount()
     * @uses Vehicle::setSite()
     * @uses Vehicle::setServiceBook()
     * @uses Vehicle::setCheckDate()
     * @uses Vehicle::setPreowners()
     * @uses Vehicle::setUCWarrranty()
     * @uses Vehicle::setWarranty()
     * @uses Vehicle::setDekraSeal()
     * @uses Vehicle::setQualitySeal()
     * @uses Vehicle::setListInHpm()
     * @uses Vehicle::setListInPrint()
     * @uses Vehicle::setAccsList()
     * @uses Vehicle::setOAccsList()
     * @uses Vehicle::setNonSmoker()
     * @uses Vehicle::setFullServiceHistory()
     * @uses Vehicle::setFreeOfAccident()
     * @uses Vehicle::setMarkets()
     * @uses Vehicle::setEmissionClass()
     * @uses Vehicle::setEmissionBadge()
     * @uses Vehicle::setEfficiencyClass()
     * @uses Vehicle::setEnergyCosts20TKm()
     * @uses Vehicle::setMotorVehicleTaxPerYear()
     * @param int $id
     * @param int $customer
     * @param string $area
     * @param string $customerVehicleId
     * @param string $creationDate
     * @param string $lastChange
     * @param \StructType\StateCollection $state
     * @param \StructType\ManufacturerCollection $manufacturer
     * @param string $model
     * @param string $smodel
     * @param int $category
     * @param int $subCategory
     * @param string $fullCategory
     * @param int $type
     * @param \StructType\SpecialStateCollection $specialState
     * @param string $byear
     * @param string $myear
     * @param string $hsn
     * @param string $tsn
     * @param string $licenseNo
     * @param string $schwacke
     * @param int $jato
     * @param int $emissionstd
     * @param int $co2
     * @param int $co2Other
     * @param \StructType\FuelConsumptionCollection $fuelConsumption
     * @param \StructType\FuelConsumptionCollection $fuelConsumptionOther
     * @param \StructType\FuelConsumptionCollection $ePowerConsumption
     * @param int $pcasco
     * @param int $ccasco
     * @param int $liability
     * @param \StructType\InspectionCollection $generalInspection
     * @param \StructType\InspectionCollection $emissionTest
     * @param string $regDate
     * @param string $suspensionDate
     * @param \StructType\InspectionDatesCollection $inspectionDates
     * @param int $km
     * @param int $condition
     * @param string $deliveryDate
     * @param int $deliveryDays
     * @param int $fuel
     * @param int $fuelOther
     * @param int $ccm
     * @param int $cylinders
     * @param int $gearbox
     * @param int $gearcount
     * @param int $drive
     * @param int $power
     * @param int $doors
     * @param int $seats
     * @param \StructType\WeightCollection $weight
     * @param \StructType\DimensionsCollection $dimensions
     * @param \StructType\UVCollection $uV
     * @param \StructType\FreetextCollection $freetext
     * @param \StructType\PriceCollection $price
     * @param \ArrayType\ArrayOfCosts $costs
     * @param \StructType\FinancingCollection $financing
     * @param \StructType\LeasingCollection $leasing
     * @param \StructType\CCFinancingCollection $cCFinancing
     * @param \StructType\ColorCollection $color
     * @param \StructType\PicturesCollection $pictures
     * @param string $keyNo
     * @param string $vIN
     * @param string $regDocNo
     * @param string $regDocPlace
     * @param string $roadNo
     * @param string $bookNo
     * @param string $radioCode
     * @param int $keyCount
     * @param string $site
     * @param int $serviceBook
     * @param string $checkDate
     * @param int $preowners
     * @param bool $uCWarrranty
     * @param \StructType\WarrantyCollection $warranty
     * @param bool $dekraSeal
     * @param int $qualitySeal
     * @param bool $listInHpm
     * @param bool $listInPrint
     * @param \StructType\AccsListCollection $accsList
     * @param \StructType\OAccsListCollection $oAccsList
     * @param bool $nonSmoker
     * @param bool $fullServiceHistory
     * @param bool $freeOfAccident
     * @param \StructType\MarketsCollection $markets
     * @param int $emissionClass
     * @param int $emissionBadge
     * @param int $efficiencyClass
     * @param \StructType\EnergyCosts20TKmCollection $energyCosts20TKm
     * @param float $motorVehicleTaxPerYear
     */
    public function __construct($id = null, $customer = null, $area = null, $customerVehicleId = null, $creationDate = null, $lastChange = null, \StructType\StateCollection $state = null, \StructType\ManufacturerCollection $manufacturer = null, $model = null, $smodel = null, $category = null, $subCategory = null, $fullCategory = null, $type = null, \StructType\SpecialStateCollection $specialState = null, $byear = null, $myear = null, $hsn = null, $tsn = null, $licenseNo = null, $schwacke = null, $jato = null, $emissionstd = null, $co2 = null, $co2Other = null, \StructType\FuelConsumptionCollection $fuelConsumption = null, \StructType\FuelConsumptionCollection $fuelConsumptionOther = null, \StructType\FuelConsumptionCollection $ePowerConsumption = null, $pcasco = null, $ccasco = null, $liability = null, \StructType\InspectionCollection $generalInspection = null, \StructType\InspectionCollection $emissionTest = null, $regDate = null, $suspensionDate = null, \StructType\InspectionDatesCollection $inspectionDates = null, $km = null, $condition = null, $deliveryDate = null, $deliveryDays = null, $fuel = null, $fuelOther = null, $ccm = null, $cylinders = null, $gearbox = null, $gearcount = null, $drive = null, $power = null, $doors = null, $seats = null, \StructType\WeightCollection $weight = null, \StructType\DimensionsCollection $dimensions = null, \StructType\UVCollection $uV = null, \StructType\FreetextCollection $freetext = null, \StructType\PriceCollection $price = null, \ArrayType\ArrayOfCosts $costs = null, \StructType\FinancingCollection $financing = null, \StructType\LeasingCollection $leasing = null, \StructType\CCFinancingCollection $cCFinancing = null, \StructType\ColorCollection $color = null, \StructType\PicturesCollection $pictures = null, $keyNo = null, $vIN = null, $regDocNo = null, $regDocPlace = null, $roadNo = null, $bookNo = null, $radioCode = null, $keyCount = null, $site = null, $serviceBook = null, $checkDate = null, $preowners = null, $uCWarrranty = null, \StructType\WarrantyCollection $warranty = null, $dekraSeal = null, $qualitySeal = null, $listInHpm = null, $listInPrint = null, \StructType\AccsListCollection $accsList = null, \StructType\OAccsListCollection $oAccsList = null, $nonSmoker = null, $fullServiceHistory = null, $freeOfAccident = null, \StructType\MarketsCollection $markets = null, $emissionClass = null, $emissionBadge = null, $efficiencyClass = null, \StructType\EnergyCosts20TKmCollection $energyCosts20TKm = null, $motorVehicleTaxPerYear = null)
    {
        $this
            ->setId($id)
            ->setCustomer($customer)
            ->setArea($area)
            ->setCustomerVehicleId($customerVehicleId)
            ->setCreationDate($creationDate)
            ->setLastChange($lastChange)
            ->setState($state)
            ->setManufacturer($manufacturer)
            ->setModel($model)
            ->setSmodel($smodel)
            ->setCategory($category)
            ->setSubCategory($subCategory)
            ->setFullCategory($fullCategory)
            ->setType($type)
            ->setSpecialState($specialState)
            ->setByear($byear)
            ->setMyear($myear)
            ->setHsn($hsn)
            ->setTsn($tsn)
            ->setLicenseNo($licenseNo)
            ->setSchwacke($schwacke)
            ->setJato($jato)
            ->setEmissionstd($emissionstd)
            ->setCo2($co2)
            ->setCo2Other($co2Other)
            ->setFuelConsumption($fuelConsumption)
            ->setFuelConsumptionOther($fuelConsumptionOther)
            ->setEPowerConsumption($ePowerConsumption)
            ->setPcasco($pcasco)
            ->setCcasco($ccasco)
            ->setLiability($liability)
            ->setGeneralInspection($generalInspection)
            ->setEmissionTest($emissionTest)
            ->setRegDate($regDate)
            ->setSuspensionDate($suspensionDate)
            ->setInspectionDates($inspectionDates)
            ->setKm($km)
            ->setCondition($condition)
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryDays($deliveryDays)
            ->setFuel($fuel)
            ->setFuelOther($fuelOther)
            ->setCcm($ccm)
            ->setCylinders($cylinders)
            ->setGearbox($gearbox)
            ->setGearcount($gearcount)
            ->setDrive($drive)
            ->setPower($power)
            ->setDoors($doors)
            ->setSeats($seats)
            ->setWeight($weight)
            ->setDimensions($dimensions)
            ->setUV($uV)
            ->setFreetext($freetext)
            ->setPrice($price)
            ->setCosts($costs)
            ->setFinancing($financing)
            ->setLeasing($leasing)
            ->setCCFinancing($cCFinancing)
            ->setColor($color)
            ->setPictures($pictures)
            ->setKeyNo($keyNo)
            ->setVIN($vIN)
            ->setRegDocNo($regDocNo)
            ->setRegDocPlace($regDocPlace)
            ->setRoadNo($roadNo)
            ->setBookNo($bookNo)
            ->setRadioCode($radioCode)
            ->setKeyCount($keyCount)
            ->setSite($site)
            ->setServiceBook($serviceBook)
            ->setCheckDate($checkDate)
            ->setPreowners($preowners)
            ->setUCWarrranty($uCWarrranty)
            ->setWarranty($warranty)
            ->setDekraSeal($dekraSeal)
            ->setQualitySeal($qualitySeal)
            ->setListInHpm($listInHpm)
            ->setListInPrint($listInPrint)
            ->setAccsList($accsList)
            ->setOAccsList($oAccsList)
            ->setNonSmoker($nonSmoker)
            ->setFullServiceHistory($fullServiceHistory)
            ->setFreeOfAccident($freeOfAccident)
            ->setMarkets($markets)
            ->setEmissionClass($emissionClass)
            ->setEmissionBadge($emissionBadge)
            ->setEfficiencyClass($efficiencyClass)
            ->setEnergyCosts20TKm($energyCosts20TKm)
            ->setMotorVehicleTaxPerYear($motorVehicleTaxPerYear);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Vehicle
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Customer value
     * @return int|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param int $customer
     * @return \StructType\Vehicle
     */
    public function setCustomer($customer = null)
    {
        // validation for constraint: int
        if (!is_null($customer) && !is_numeric($customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer)), __LINE__);
        }
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Area value
     * @return string|null
     */
    public function getArea()
    {
        return $this->Area;
    }
    /**
     * Set Area value
     * @param string $area
     * @return \StructType\Vehicle
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area)), __LINE__);
        }
        $this->Area = $area;
        return $this;
    }
    /**
     * Get CustomerVehicleId value
     * @return string|null
     */
    public function getCustomerVehicleId()
    {
        return $this->CustomerVehicleId;
    }
    /**
     * Set CustomerVehicleId value
     * @param string $customerVehicleId
     * @return \StructType\Vehicle
     */
    public function setCustomerVehicleId($customerVehicleId = null)
    {
        // validation for constraint: string
        if (!is_null($customerVehicleId) && !is_string($customerVehicleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerVehicleId)), __LINE__);
        }
        $this->CustomerVehicleId = $customerVehicleId;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\Vehicle
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get LastChange value
     * @return string|null
     */
    public function getLastChange()
    {
        return $this->LastChange;
    }
    /**
     * Set LastChange value
     * @param string $lastChange
     * @return \StructType\Vehicle
     */
    public function setLastChange($lastChange = null)
    {
        // validation for constraint: string
        if (!is_null($lastChange) && !is_string($lastChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastChange)), __LINE__);
        }
        $this->LastChange = $lastChange;
        return $this;
    }
    /**
     * Get State value
     * @return \StructType\StateCollection|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param \StructType\StateCollection $state
     * @return \StructType\Vehicle
     */
    public function setState(\StructType\StateCollection $state = null)
    {
        $this->State = $state;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return \StructType\ManufacturerCollection|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param \StructType\ManufacturerCollection $manufacturer
     * @return \StructType\Vehicle
     */
    public function setManufacturer(\StructType\ManufacturerCollection $manufacturer = null)
    {
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get Model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->Model;
    }
    /**
     * Set Model value
     * @param string $model
     * @return \StructType\Vehicle
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($model)), __LINE__);
        }
        $this->Model = $model;
        return $this;
    }
    /**
     * Get Smodel value
     * @return string|null
     */
    public function getSmodel()
    {
        return $this->Smodel;
    }
    /**
     * Set Smodel value
     * @param string $smodel
     * @return \StructType\Vehicle
     */
    public function setSmodel($smodel = null)
    {
        // validation for constraint: string
        if (!is_null($smodel) && !is_string($smodel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($smodel)), __LINE__);
        }
        $this->Smodel = $smodel;
        return $this;
    }
    /**
     * Get Category value
     * @return int|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param int $category
     * @return \StructType\Vehicle
     */
    public function setCategory($category = null)
    {
        // validation for constraint: int
        if (!is_null($category) && !is_numeric($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get SubCategory value
     * @return int|null
     */
    public function getSubCategory()
    {
        return $this->SubCategory;
    }
    /**
     * Set SubCategory value
     * @param int $subCategory
     * @return \StructType\Vehicle
     */
    public function setSubCategory($subCategory = null)
    {
        // validation for constraint: int
        if (!is_null($subCategory) && !is_numeric($subCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subCategory)), __LINE__);
        }
        $this->SubCategory = $subCategory;
        return $this;
    }
    /**
     * Get FullCategory value
     * @return string|null
     */
    public function getFullCategory()
    {
        return $this->FullCategory;
    }
    /**
     * Set FullCategory value
     * @param string $fullCategory
     * @return \StructType\Vehicle
     */
    public function setFullCategory($fullCategory = null)
    {
        // validation for constraint: string
        if (!is_null($fullCategory) && !is_string($fullCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullCategory)), __LINE__);
        }
        $this->FullCategory = $fullCategory;
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\Vehicle
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get SpecialState value
     * @return \StructType\SpecialStateCollection|null
     */
    public function getSpecialState()
    {
        return $this->SpecialState;
    }
    /**
     * Set SpecialState value
     * @param \StructType\SpecialStateCollection $specialState
     * @return \StructType\Vehicle
     */
    public function setSpecialState(\StructType\SpecialStateCollection $specialState = null)
    {
        $this->SpecialState = $specialState;
        return $this;
    }
    /**
     * Get Byear value
     * @return string|null
     */
    public function getByear()
    {
        return $this->Byear;
    }
    /**
     * Set Byear value
     * @param string $byear
     * @return \StructType\Vehicle
     */
    public function setByear($byear = null)
    {
        // validation for constraint: string
        if (!is_null($byear) && !is_string($byear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($byear)), __LINE__);
        }
        $this->Byear = $byear;
        return $this;
    }
    /**
     * Get Myear value
     * @return string|null
     */
    public function getMyear()
    {
        return $this->Myear;
    }
    /**
     * Set Myear value
     * @param string $myear
     * @return \StructType\Vehicle
     */
    public function setMyear($myear = null)
    {
        // validation for constraint: string
        if (!is_null($myear) && !is_string($myear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($myear)), __LINE__);
        }
        $this->Myear = $myear;
        return $this;
    }
    /**
     * Get Hsn value
     * @return string|null
     */
    public function getHsn()
    {
        return $this->Hsn;
    }
    /**
     * Set Hsn value
     * @param string $hsn
     * @return \StructType\Vehicle
     */
    public function setHsn($hsn = null)
    {
        // validation for constraint: string
        if (!is_null($hsn) && !is_string($hsn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hsn)), __LINE__);
        }
        $this->Hsn = $hsn;
        return $this;
    }
    /**
     * Get Tsn value
     * @return string|null
     */
    public function getTsn()
    {
        return $this->Tsn;
    }
    /**
     * Set Tsn value
     * @param string $tsn
     * @return \StructType\Vehicle
     */
    public function setTsn($tsn = null)
    {
        // validation for constraint: string
        if (!is_null($tsn) && !is_string($tsn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tsn)), __LINE__);
        }
        $this->Tsn = $tsn;
        return $this;
    }
    /**
     * Get LicenseNo value
     * @return string|null
     */
    public function getLicenseNo()
    {
        return $this->LicenseNo;
    }
    /**
     * Set LicenseNo value
     * @param string $licenseNo
     * @return \StructType\Vehicle
     */
    public function setLicenseNo($licenseNo = null)
    {
        // validation for constraint: string
        if (!is_null($licenseNo) && !is_string($licenseNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseNo)), __LINE__);
        }
        $this->LicenseNo = $licenseNo;
        return $this;
    }
    /**
     * Get Schwacke value
     * @return string|null
     */
    public function getSchwacke()
    {
        return $this->Schwacke;
    }
    /**
     * Set Schwacke value
     * @param string $schwacke
     * @return \StructType\Vehicle
     */
    public function setSchwacke($schwacke = null)
    {
        // validation for constraint: string
        if (!is_null($schwacke) && !is_string($schwacke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schwacke)), __LINE__);
        }
        $this->Schwacke = $schwacke;
        return $this;
    }
    /**
     * Get Jato value
     * @return int|null
     */
    public function getJato()
    {
        return $this->Jato;
    }
    /**
     * Set Jato value
     * @param int $jato
     * @return \StructType\Vehicle
     */
    public function setJato($jato = null)
    {
        // validation for constraint: int
        if (!is_null($jato) && !is_numeric($jato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($jato)), __LINE__);
        }
        $this->Jato = $jato;
        return $this;
    }
    /**
     * Get Emissionstd value
     * @return int|null
     */
    public function getEmissionstd()
    {
        return $this->Emissionstd;
    }
    /**
     * Set Emissionstd value
     * @param int $emissionstd
     * @return \StructType\Vehicle
     */
    public function setEmissionstd($emissionstd = null)
    {
        // validation for constraint: int
        if (!is_null($emissionstd) && !is_numeric($emissionstd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($emissionstd)), __LINE__);
        }
        $this->Emissionstd = $emissionstd;
        return $this;
    }
    /**
     * Get Co2 value
     * @return int|null
     */
    public function getCo2()
    {
        return $this->Co2;
    }
    /**
     * Set Co2 value
     * @param int $co2
     * @return \StructType\Vehicle
     */
    public function setCo2($co2 = null)
    {
        // validation for constraint: int
        if (!is_null($co2) && !is_numeric($co2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($co2)), __LINE__);
        }
        $this->Co2 = $co2;
        return $this;
    }
    /**
     * Get Co2Other value
     * @return int|null
     */
    public function getCo2Other()
    {
        return $this->Co2Other;
    }
    /**
     * Set Co2Other value
     * @param int $co2Other
     * @return \StructType\Vehicle
     */
    public function setCo2Other($co2Other = null)
    {
        // validation for constraint: int
        if (!is_null($co2Other) && !is_numeric($co2Other)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($co2Other)), __LINE__);
        }
        $this->Co2Other = $co2Other;
        return $this;
    }
    /**
     * Get FuelConsumption value
     * @return \StructType\FuelConsumptionCollection|null
     */
    public function getFuelConsumption()
    {
        return $this->FuelConsumption;
    }
    /**
     * Set FuelConsumption value
     * @param \StructType\FuelConsumptionCollection $fuelConsumption
     * @return \StructType\Vehicle
     */
    public function setFuelConsumption(\StructType\FuelConsumptionCollection $fuelConsumption = null)
    {
        $this->FuelConsumption = $fuelConsumption;
        return $this;
    }
    /**
     * Get FuelConsumptionOther value
     * @return \StructType\FuelConsumptionCollection|null
     */
    public function getFuelConsumptionOther()
    {
        return $this->FuelConsumptionOther;
    }
    /**
     * Set FuelConsumptionOther value
     * @param \StructType\FuelConsumptionCollection $fuelConsumptionOther
     * @return \StructType\Vehicle
     */
    public function setFuelConsumptionOther(\StructType\FuelConsumptionCollection $fuelConsumptionOther = null)
    {
        $this->FuelConsumptionOther = $fuelConsumptionOther;
        return $this;
    }
    /**
     * Get EPowerConsumption value
     * @return \StructType\FuelConsumptionCollection|null
     */
    public function getEPowerConsumption()
    {
        return $this->EPowerConsumption;
    }
    /**
     * Set EPowerConsumption value
     * @param \StructType\FuelConsumptionCollection $ePowerConsumption
     * @return \StructType\Vehicle
     */
    public function setEPowerConsumption(\StructType\FuelConsumptionCollection $ePowerConsumption = null)
    {
        $this->EPowerConsumption = $ePowerConsumption;
        return $this;
    }
    /**
     * Get Pcasco value
     * @return int|null
     */
    public function getPcasco()
    {
        return $this->Pcasco;
    }
    /**
     * Set Pcasco value
     * @param int $pcasco
     * @return \StructType\Vehicle
     */
    public function setPcasco($pcasco = null)
    {
        // validation for constraint: int
        if (!is_null($pcasco) && !is_numeric($pcasco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pcasco)), __LINE__);
        }
        $this->Pcasco = $pcasco;
        return $this;
    }
    /**
     * Get Ccasco value
     * @return int|null
     */
    public function getCcasco()
    {
        return $this->Ccasco;
    }
    /**
     * Set Ccasco value
     * @param int $ccasco
     * @return \StructType\Vehicle
     */
    public function setCcasco($ccasco = null)
    {
        // validation for constraint: int
        if (!is_null($ccasco) && !is_numeric($ccasco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ccasco)), __LINE__);
        }
        $this->Ccasco = $ccasco;
        return $this;
    }
    /**
     * Get Liability value
     * @return int|null
     */
    public function getLiability()
    {
        return $this->Liability;
    }
    /**
     * Set Liability value
     * @param int $liability
     * @return \StructType\Vehicle
     */
    public function setLiability($liability = null)
    {
        // validation for constraint: int
        if (!is_null($liability) && !is_numeric($liability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($liability)), __LINE__);
        }
        $this->Liability = $liability;
        return $this;
    }
    /**
     * Get GeneralInspection value
     * @return \StructType\InspectionCollection|null
     */
    public function getGeneralInspection()
    {
        return $this->GeneralInspection;
    }
    /**
     * Set GeneralInspection value
     * @param \StructType\InspectionCollection $generalInspection
     * @return \StructType\Vehicle
     */
    public function setGeneralInspection(\StructType\InspectionCollection $generalInspection = null)
    {
        $this->GeneralInspection = $generalInspection;
        return $this;
    }
    /**
     * Get EmissionTest value
     * @return \StructType\InspectionCollection|null
     */
    public function getEmissionTest()
    {
        return $this->EmissionTest;
    }
    /**
     * Set EmissionTest value
     * @param \StructType\InspectionCollection $emissionTest
     * @return \StructType\Vehicle
     */
    public function setEmissionTest(\StructType\InspectionCollection $emissionTest = null)
    {
        $this->EmissionTest = $emissionTest;
        return $this;
    }
    /**
     * Get RegDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->RegDate;
    }
    /**
     * Set RegDate value
     * @param string $regDate
     * @return \StructType\Vehicle
     */
    public function setRegDate($regDate = null)
    {
        // validation for constraint: string
        if (!is_null($regDate) && !is_string($regDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDate)), __LINE__);
        }
        $this->RegDate = $regDate;
        return $this;
    }
    /**
     * Get SuspensionDate value
     * @return string|null
     */
    public function getSuspensionDate()
    {
        return $this->SuspensionDate;
    }
    /**
     * Set SuspensionDate value
     * @param string $suspensionDate
     * @return \StructType\Vehicle
     */
    public function setSuspensionDate($suspensionDate = null)
    {
        // validation for constraint: string
        if (!is_null($suspensionDate) && !is_string($suspensionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suspensionDate)), __LINE__);
        }
        $this->SuspensionDate = $suspensionDate;
        return $this;
    }
    /**
     * Get InspectionDates value
     * @return \StructType\InspectionDatesCollection|null
     */
    public function getInspectionDates()
    {
        return $this->InspectionDates;
    }
    /**
     * Set InspectionDates value
     * @param \StructType\InspectionDatesCollection $inspectionDates
     * @return \StructType\Vehicle
     */
    public function setInspectionDates(\StructType\InspectionDatesCollection $inspectionDates = null)
    {
        $this->InspectionDates = $inspectionDates;
        return $this;
    }
    /**
     * Get Km value
     * @return int|null
     */
    public function getKm()
    {
        return $this->Km;
    }
    /**
     * Set Km value
     * @param int $km
     * @return \StructType\Vehicle
     */
    public function setKm($km = null)
    {
        // validation for constraint: int
        if (!is_null($km) && !is_numeric($km)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($km)), __LINE__);
        }
        $this->Km = $km;
        return $this;
    }
    /**
     * Get Condition value
     * @return int|null
     */
    public function getCondition()
    {
        return $this->Condition;
    }
    /**
     * Set Condition value
     * @param int $condition
     * @return \StructType\Vehicle
     */
    public function setCondition($condition = null)
    {
        // validation for constraint: int
        if (!is_null($condition) && !is_numeric($condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($condition)), __LINE__);
        }
        $this->Condition = $condition;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\Vehicle
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DeliveryDays value
     * @return int|null
     */
    public function getDeliveryDays()
    {
        return $this->DeliveryDays;
    }
    /**
     * Set DeliveryDays value
     * @param int $deliveryDays
     * @return \StructType\Vehicle
     */
    public function setDeliveryDays($deliveryDays = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryDays) && !is_numeric($deliveryDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deliveryDays)), __LINE__);
        }
        $this->DeliveryDays = $deliveryDays;
        return $this;
    }
    /**
     * Get Fuel value
     * @return int|null
     */
    public function getFuel()
    {
        return $this->Fuel;
    }
    /**
     * Set Fuel value
     * @param int $fuel
     * @return \StructType\Vehicle
     */
    public function setFuel($fuel = null)
    {
        // validation for constraint: int
        if (!is_null($fuel) && !is_numeric($fuel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuel)), __LINE__);
        }
        $this->Fuel = $fuel;
        return $this;
    }
    /**
     * Get FuelOther value
     * @return int|null
     */
    public function getFuelOther()
    {
        return $this->FuelOther;
    }
    /**
     * Set FuelOther value
     * @param int $fuelOther
     * @return \StructType\Vehicle
     */
    public function setFuelOther($fuelOther = null)
    {
        // validation for constraint: int
        if (!is_null($fuelOther) && !is_numeric($fuelOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelOther)), __LINE__);
        }
        $this->FuelOther = $fuelOther;
        return $this;
    }
    /**
     * Get Ccm value
     * @return int|null
     */
    public function getCcm()
    {
        return $this->Ccm;
    }
    /**
     * Set Ccm value
     * @param int $ccm
     * @return \StructType\Vehicle
     */
    public function setCcm($ccm = null)
    {
        // validation for constraint: int
        if (!is_null($ccm) && !is_numeric($ccm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ccm)), __LINE__);
        }
        $this->Ccm = $ccm;
        return $this;
    }
    /**
     * Get Cylinders value
     * @return int|null
     */
    public function getCylinders()
    {
        return $this->Cylinders;
    }
    /**
     * Set Cylinders value
     * @param int $cylinders
     * @return \StructType\Vehicle
     */
    public function setCylinders($cylinders = null)
    {
        // validation for constraint: int
        if (!is_null($cylinders) && !is_numeric($cylinders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cylinders)), __LINE__);
        }
        $this->Cylinders = $cylinders;
        return $this;
    }
    /**
     * Get Gearbox value
     * @return int|null
     */
    public function getGearbox()
    {
        return $this->Gearbox;
    }
    /**
     * Set Gearbox value
     * @param int $gearbox
     * @return \StructType\Vehicle
     */
    public function setGearbox($gearbox = null)
    {
        // validation for constraint: int
        if (!is_null($gearbox) && !is_numeric($gearbox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gearbox)), __LINE__);
        }
        $this->Gearbox = $gearbox;
        return $this;
    }
    /**
     * Get Gearcount value
     * @return int|null
     */
    public function getGearcount()
    {
        return $this->Gearcount;
    }
    /**
     * Set Gearcount value
     * @param int $gearcount
     * @return \StructType\Vehicle
     */
    public function setGearcount($gearcount = null)
    {
        // validation for constraint: int
        if (!is_null($gearcount) && !is_numeric($gearcount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gearcount)), __LINE__);
        }
        $this->Gearcount = $gearcount;
        return $this;
    }
    /**
     * Get Drive value
     * @return int|null
     */
    public function getDrive()
    {
        return $this->Drive;
    }
    /**
     * Set Drive value
     * @param int $drive
     * @return \StructType\Vehicle
     */
    public function setDrive($drive = null)
    {
        // validation for constraint: int
        if (!is_null($drive) && !is_numeric($drive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($drive)), __LINE__);
        }
        $this->Drive = $drive;
        return $this;
    }
    /**
     * Get Power value
     * @return int|null
     */
    public function getPower()
    {
        return $this->Power;
    }
    /**
     * Set Power value
     * @param int $power
     * @return \StructType\Vehicle
     */
    public function setPower($power = null)
    {
        // validation for constraint: int
        if (!is_null($power) && !is_numeric($power)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($power)), __LINE__);
        }
        $this->Power = $power;
        return $this;
    }
    /**
     * Get Doors value
     * @return int|null
     */
    public function getDoors()
    {
        return $this->Doors;
    }
    /**
     * Set Doors value
     * @param int $doors
     * @return \StructType\Vehicle
     */
    public function setDoors($doors = null)
    {
        // validation for constraint: int
        if (!is_null($doors) && !is_numeric($doors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($doors)), __LINE__);
        }
        $this->Doors = $doors;
        return $this;
    }
    /**
     * Get Seats value
     * @return int|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param int $seats
     * @return \StructType\Vehicle
     */
    public function setSeats($seats = null)
    {
        // validation for constraint: int
        if (!is_null($seats) && !is_numeric($seats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seats)), __LINE__);
        }
        $this->Seats = $seats;
        return $this;
    }
    /**
     * Get Weight value
     * @return \StructType\WeightCollection|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param \StructType\WeightCollection $weight
     * @return \StructType\Vehicle
     */
    public function setWeight(\StructType\WeightCollection $weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \StructType\DimensionsCollection|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \StructType\DimensionsCollection $dimensions
     * @return \StructType\Vehicle
     */
    public function setDimensions(\StructType\DimensionsCollection $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get UV value
     * @return \StructType\UVCollection|null
     */
    public function getUV()
    {
        return $this->UV;
    }
    /**
     * Set UV value
     * @param \StructType\UVCollection $uV
     * @return \StructType\Vehicle
     */
    public function setUV(\StructType\UVCollection $uV = null)
    {
        $this->UV = $uV;
        return $this;
    }
    /**
     * Get Freetext value
     * @return \StructType\FreetextCollection|null
     */
    public function getFreetext()
    {
        return $this->Freetext;
    }
    /**
     * Set Freetext value
     * @param \StructType\FreetextCollection $freetext
     * @return \StructType\Vehicle
     */
    public function setFreetext(\StructType\FreetextCollection $freetext = null)
    {
        $this->Freetext = $freetext;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceCollection|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceCollection $price
     * @return \StructType\Vehicle
     */
    public function setPrice(\StructType\PriceCollection $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Costs value
     * @return \ArrayType\ArrayOfCosts|null
     */
    public function getCosts()
    {
        return $this->Costs;
    }
    /**
     * Set Costs value
     * @param \ArrayType\ArrayOfCosts $costs
     * @return \StructType\Vehicle
     */
    public function setCosts(\ArrayType\ArrayOfCosts $costs = null)
    {
        $this->Costs = $costs;
        return $this;
    }
    /**
     * Get Financing value
     * @return \StructType\FinancingCollection|null
     */
    public function getFinancing()
    {
        return $this->Financing;
    }
    /**
     * Set Financing value
     * @param \StructType\FinancingCollection $financing
     * @return \StructType\Vehicle
     */
    public function setFinancing(\StructType\FinancingCollection $financing = null)
    {
        $this->Financing = $financing;
        return $this;
    }
    /**
     * Get Leasing value
     * @return \StructType\LeasingCollection|null
     */
    public function getLeasing()
    {
        return $this->Leasing;
    }
    /**
     * Set Leasing value
     * @param \StructType\LeasingCollection $leasing
     * @return \StructType\Vehicle
     */
    public function setLeasing(\StructType\LeasingCollection $leasing = null)
    {
        $this->Leasing = $leasing;
        return $this;
    }
    /**
     * Get CCFinancing value
     * @return \StructType\CCFinancingCollection|null
     */
    public function getCCFinancing()
    {
        return $this->CCFinancing;
    }
    /**
     * Set CCFinancing value
     * @param \StructType\CCFinancingCollection $cCFinancing
     * @return \StructType\Vehicle
     */
    public function setCCFinancing(\StructType\CCFinancingCollection $cCFinancing = null)
    {
        $this->CCFinancing = $cCFinancing;
        return $this;
    }
    /**
     * Get Color value
     * @return \StructType\ColorCollection|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param \StructType\ColorCollection $color
     * @return \StructType\Vehicle
     */
    public function setColor(\StructType\ColorCollection $color = null)
    {
        $this->Color = $color;
        return $this;
    }
    /**
     * Get Pictures value
     * @return \StructType\PicturesCollection|null
     */
    public function getPictures()
    {
        return $this->Pictures;
    }
    /**
     * Set Pictures value
     * @param \StructType\PicturesCollection $pictures
     * @return \StructType\Vehicle
     */
    public function setPictures(\StructType\PicturesCollection $pictures = null)
    {
        $this->Pictures = $pictures;
        return $this;
    }
    /**
     * Get KeyNo value
     * @return string|null
     */
    public function getKeyNo()
    {
        return $this->KeyNo;
    }
    /**
     * Set KeyNo value
     * @param string $keyNo
     * @return \StructType\Vehicle
     */
    public function setKeyNo($keyNo = null)
    {
        // validation for constraint: string
        if (!is_null($keyNo) && !is_string($keyNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyNo)), __LINE__);
        }
        $this->KeyNo = $keyNo;
        return $this;
    }
    /**
     * Get VIN value
     * @return string|null
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\Vehicle
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vIN)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get RegDocNo value
     * @return string|null
     */
    public function getRegDocNo()
    {
        return $this->RegDocNo;
    }
    /**
     * Set RegDocNo value
     * @param string $regDocNo
     * @return \StructType\Vehicle
     */
    public function setRegDocNo($regDocNo = null)
    {
        // validation for constraint: string
        if (!is_null($regDocNo) && !is_string($regDocNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDocNo)), __LINE__);
        }
        $this->RegDocNo = $regDocNo;
        return $this;
    }
    /**
     * Get RegDocPlace value
     * @return string|null
     */
    public function getRegDocPlace()
    {
        return $this->RegDocPlace;
    }
    /**
     * Set RegDocPlace value
     * @param string $regDocPlace
     * @return \StructType\Vehicle
     */
    public function setRegDocPlace($regDocPlace = null)
    {
        // validation for constraint: string
        if (!is_null($regDocPlace) && !is_string($regDocPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDocPlace)), __LINE__);
        }
        $this->RegDocPlace = $regDocPlace;
        return $this;
    }
    /**
     * Get RoadNo value
     * @return string|null
     */
    public function getRoadNo()
    {
        return $this->RoadNo;
    }
    /**
     * Set RoadNo value
     * @param string $roadNo
     * @return \StructType\Vehicle
     */
    public function setRoadNo($roadNo = null)
    {
        // validation for constraint: string
        if (!is_null($roadNo) && !is_string($roadNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roadNo)), __LINE__);
        }
        $this->RoadNo = $roadNo;
        return $this;
    }
    /**
     * Get BookNo value
     * @return string|null
     */
    public function getBookNo()
    {
        return $this->BookNo;
    }
    /**
     * Set BookNo value
     * @param string $bookNo
     * @return \StructType\Vehicle
     */
    public function setBookNo($bookNo = null)
    {
        // validation for constraint: string
        if (!is_null($bookNo) && !is_string($bookNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookNo)), __LINE__);
        }
        $this->BookNo = $bookNo;
        return $this;
    }
    /**
     * Get RadioCode value
     * @return string|null
     */
    public function getRadioCode()
    {
        return $this->RadioCode;
    }
    /**
     * Set RadioCode value
     * @param string $radioCode
     * @return \StructType\Vehicle
     */
    public function setRadioCode($radioCode = null)
    {
        // validation for constraint: string
        if (!is_null($radioCode) && !is_string($radioCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($radioCode)), __LINE__);
        }
        $this->RadioCode = $radioCode;
        return $this;
    }
    /**
     * Get KeyCount value
     * @return int|null
     */
    public function getKeyCount()
    {
        return $this->KeyCount;
    }
    /**
     * Set KeyCount value
     * @param int $keyCount
     * @return \StructType\Vehicle
     */
    public function setKeyCount($keyCount = null)
    {
        // validation for constraint: int
        if (!is_null($keyCount) && !is_numeric($keyCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($keyCount)), __LINE__);
        }
        $this->KeyCount = $keyCount;
        return $this;
    }
    /**
     * Get Site value
     * @return string|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param string $site
     * @return \StructType\Vehicle
     */
    public function setSite($site = null)
    {
        // validation for constraint: string
        if (!is_null($site) && !is_string($site)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($site)), __LINE__);
        }
        $this->Site = $site;
        return $this;
    }
    /**
     * Get ServiceBook value
     * @return int|null
     */
    public function getServiceBook()
    {
        return $this->ServiceBook;
    }
    /**
     * Set ServiceBook value
     * @param int $serviceBook
     * @return \StructType\Vehicle
     */
    public function setServiceBook($serviceBook = null)
    {
        // validation for constraint: int
        if (!is_null($serviceBook) && !is_numeric($serviceBook)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceBook)), __LINE__);
        }
        $this->ServiceBook = $serviceBook;
        return $this;
    }
    /**
     * Get CheckDate value
     * @return string|null
     */
    public function getCheckDate()
    {
        return $this->CheckDate;
    }
    /**
     * Set CheckDate value
     * @param string $checkDate
     * @return \StructType\Vehicle
     */
    public function setCheckDate($checkDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkDate) && !is_string($checkDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkDate)), __LINE__);
        }
        $this->CheckDate = $checkDate;
        return $this;
    }
    /**
     * Get Preowners value
     * @return int|null
     */
    public function getPreowners()
    {
        return $this->Preowners;
    }
    /**
     * Set Preowners value
     * @param int $preowners
     * @return \StructType\Vehicle
     */
    public function setPreowners($preowners = null)
    {
        // validation for constraint: int
        if (!is_null($preowners) && !is_numeric($preowners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($preowners)), __LINE__);
        }
        $this->Preowners = $preowners;
        return $this;
    }
    /**
     * Get UCWarrranty value
     * @return bool|null
     */
    public function getUCWarrranty()
    {
        return $this->UCWarrranty;
    }
    /**
     * Set UCWarrranty value
     * @param bool $uCWarrranty
     * @return \StructType\Vehicle
     */
    public function setUCWarrranty($uCWarrranty = null)
    {
        $this->UCWarrranty = $uCWarrranty;
        return $this;
    }
    /**
     * Get Warranty value
     * @return \StructType\WarrantyCollection|null
     */
    public function getWarranty()
    {
        return $this->Warranty;
    }
    /**
     * Set Warranty value
     * @param \StructType\WarrantyCollection $warranty
     * @return \StructType\Vehicle
     */
    public function setWarranty(\StructType\WarrantyCollection $warranty = null)
    {
        $this->Warranty = $warranty;
        return $this;
    }
    /**
     * Get DekraSeal value
     * @return bool|null
     */
    public function getDekraSeal()
    {
        return $this->DekraSeal;
    }
    /**
     * Set DekraSeal value
     * @param bool $dekraSeal
     * @return \StructType\Vehicle
     */
    public function setDekraSeal($dekraSeal = null)
    {
        $this->DekraSeal = $dekraSeal;
        return $this;
    }
    /**
     * Get QualitySeal value
     * @return int|null
     */
    public function getQualitySeal()
    {
        return $this->QualitySeal;
    }
    /**
     * Set QualitySeal value
     * @param int $qualitySeal
     * @return \StructType\Vehicle
     */
    public function setQualitySeal($qualitySeal = null)
    {
        // validation for constraint: int
        if (!is_null($qualitySeal) && !is_numeric($qualitySeal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($qualitySeal)), __LINE__);
        }
        $this->QualitySeal = $qualitySeal;
        return $this;
    }
    /**
     * Get ListInHpm value
     * @return bool|null
     */
    public function getListInHpm()
    {
        return $this->ListInHpm;
    }
    /**
     * Set ListInHpm value
     * @param bool $listInHpm
     * @return \StructType\Vehicle
     */
    public function setListInHpm($listInHpm = null)
    {
        $this->ListInHpm = $listInHpm;
        return $this;
    }
    /**
     * Get ListInPrint value
     * @return bool|null
     */
    public function getListInPrint()
    {
        return $this->ListInPrint;
    }
    /**
     * Set ListInPrint value
     * @param bool $listInPrint
     * @return \StructType\Vehicle
     */
    public function setListInPrint($listInPrint = null)
    {
        $this->ListInPrint = $listInPrint;
        return $this;
    }
    /**
     * Get AccsList value
     * @return \StructType\AccsListCollection|null
     */
    public function getAccsList()
    {
        return $this->AccsList;
    }
    /**
     * Set AccsList value
     * @param \StructType\AccsListCollection $accsList
     * @return \StructType\Vehicle
     */
    public function setAccsList(\StructType\AccsListCollection $accsList = null)
    {
        $this->AccsList = $accsList;
        return $this;
    }
    /**
     * Get OAccsList value
     * @return \StructType\OAccsListCollection|null
     */
    public function getOAccsList()
    {
        return $this->OAccsList;
    }
    /**
     * Set OAccsList value
     * @param \StructType\OAccsListCollection $oAccsList
     * @return \StructType\Vehicle
     */
    public function setOAccsList(\StructType\OAccsListCollection $oAccsList = null)
    {
        $this->OAccsList = $oAccsList;
        return $this;
    }
    /**
     * Get NonSmoker value
     * @return bool|null
     */
    public function getNonSmoker()
    {
        return $this->NonSmoker;
    }
    /**
     * Set NonSmoker value
     * @param bool $nonSmoker
     * @return \StructType\Vehicle
     */
    public function setNonSmoker($nonSmoker = null)
    {
        $this->NonSmoker = $nonSmoker;
        return $this;
    }
    /**
     * Get FullServiceHistory value
     * @return bool|null
     */
    public function getFullServiceHistory()
    {
        return $this->FullServiceHistory;
    }
    /**
     * Set FullServiceHistory value
     * @param bool $fullServiceHistory
     * @return \StructType\Vehicle
     */
    public function setFullServiceHistory($fullServiceHistory = null)
    {
        $this->FullServiceHistory = $fullServiceHistory;
        return $this;
    }
    /**
     * Get FreeOfAccident value
     * @return bool|null
     */
    public function getFreeOfAccident()
    {
        return $this->FreeOfAccident;
    }
    /**
     * Set FreeOfAccident value
     * @param bool $freeOfAccident
     * @return \StructType\Vehicle
     */
    public function setFreeOfAccident($freeOfAccident = null)
    {
        $this->FreeOfAccident = $freeOfAccident;
        return $this;
    }
    /**
     * Get Markets value
     * @return \StructType\MarketsCollection|null
     */
    public function getMarkets()
    {
        return $this->Markets;
    }
    /**
     * Set Markets value
     * @param \StructType\MarketsCollection $markets
     * @return \StructType\Vehicle
     */
    public function setMarkets(\StructType\MarketsCollection $markets = null)
    {
        $this->Markets = $markets;
        return $this;
    }
    /**
     * Get EmissionClass value
     * @return int|null
     */
    public function getEmissionClass()
    {
        return $this->EmissionClass;
    }
    /**
     * Set EmissionClass value
     * @param int $emissionClass
     * @return \StructType\Vehicle
     */
    public function setEmissionClass($emissionClass = null)
    {
        // validation for constraint: int
        if (!is_null($emissionClass) && !is_numeric($emissionClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($emissionClass)), __LINE__);
        }
        $this->EmissionClass = $emissionClass;
        return $this;
    }
    /**
     * Get EmissionBadge value
     * @return int|null
     */
    public function getEmissionBadge()
    {
        return $this->EmissionBadge;
    }
    /**
     * Set EmissionBadge value
     * @param int $emissionBadge
     * @return \StructType\Vehicle
     */
    public function setEmissionBadge($emissionBadge = null)
    {
        // validation for constraint: int
        if (!is_null($emissionBadge) && !is_numeric($emissionBadge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($emissionBadge)), __LINE__);
        }
        $this->EmissionBadge = $emissionBadge;
        return $this;
    }
    /**
     * Get EfficiencyClass value
     * @return int|null
     */
    public function getEfficiencyClass()
    {
        return $this->EfficiencyClass;
    }
    /**
     * Set EfficiencyClass value
     * @param int $efficiencyClass
     * @return \StructType\Vehicle
     */
    public function setEfficiencyClass($efficiencyClass = null)
    {
        // validation for constraint: int
        if (!is_null($efficiencyClass) && !is_numeric($efficiencyClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($efficiencyClass)), __LINE__);
        }
        $this->EfficiencyClass = $efficiencyClass;
        return $this;
    }
    /**
     * Get EnergyCosts20TKm value
     * @return \StructType\EnergyCosts20TKmCollection|null
     */
    public function getEnergyCosts20TKm()
    {
        return $this->EnergyCosts20TKm;
    }
    /**
     * Set EnergyCosts20TKm value
     * @param \StructType\EnergyCosts20TKmCollection $energyCosts20TKm
     * @return \StructType\Vehicle
     */
    public function setEnergyCosts20TKm(\StructType\EnergyCosts20TKmCollection $energyCosts20TKm = null)
    {
        $this->EnergyCosts20TKm = $energyCosts20TKm;
        return $this;
    }
    /**
     * Get MotorVehicleTaxPerYear value
     * @return float|null
     */
    public function getMotorVehicleTaxPerYear()
    {
        return $this->MotorVehicleTaxPerYear;
    }
    /**
     * Set MotorVehicleTaxPerYear value
     * @param float $motorVehicleTaxPerYear
     * @return \StructType\Vehicle
     */
    public function setMotorVehicleTaxPerYear($motorVehicleTaxPerYear = null)
    {
        $this->MotorVehicleTaxPerYear = $motorVehicleTaxPerYear;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vehicle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
