<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TranslationsType StructType
 * @subpackage Structs
 */
class TranslationsType extends AbstractStructBase
{
    /**
     * The BaseLangKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BaseLangKey;
    /**
     * The Translations
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TranslationPair[]
     */
    public $Translations;
    /**
     * Constructor method for TranslationsType
     * @uses TranslationsType::setBaseLangKey()
     * @uses TranslationsType::setTranslations()
     * @param string $baseLangKey
     * @param \StructType\TranslationPair[] $translations
     */
    public function __construct($baseLangKey = null, array $translations = array())
    {
        $this
            ->setBaseLangKey($baseLangKey)
            ->setTranslations($translations);
    }
    /**
     * Get BaseLangKey value
     * @return string
     */
    public function getBaseLangKey()
    {
        return $this->BaseLangKey;
    }
    /**
     * Set BaseLangKey value
     * @param string $baseLangKey
     * @return \StructType\TranslationsType
     */
    public function setBaseLangKey($baseLangKey = null)
    {
        // validation for constraint: string
        if (!is_null($baseLangKey) && !is_string($baseLangKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseLangKey)), __LINE__);
        }
        $this->BaseLangKey = $baseLangKey;
        return $this;
    }
    /**
     * Get Translations value
     * @return \StructType\TranslationPair[]|null
     */
    public function getTranslations()
    {
        return $this->Translations;
    }
    /**
     * Set Translations value
     * @throws \InvalidArgumentException
     * @param \StructType\TranslationPair[] $translations
     * @return \StructType\TranslationsType
     */
    public function setTranslations(array $translations = array())
    {
        foreach ($translations as $translationsTypeTranslationsItem) {
            // validation for constraint: itemType
            if (!$translationsTypeTranslationsItem instanceof \StructType\TranslationPair) {
                throw new \InvalidArgumentException(sprintf('The Translations property can only contain items of \StructType\TranslationPair, "%s" given', is_object($translationsTypeTranslationsItem) ? get_class($translationsTypeTranslationsItem) : gettype($translationsTypeTranslationsItem)), __LINE__);
            }
        }
        $this->Translations = $translations;
        return $this;
    }
    /**
     * Add item to Translations value
     * @throws \InvalidArgumentException
     * @param \StructType\TranslationPair $item
     * @return \StructType\TranslationsType
     */
    public function addToTranslations(\StructType\TranslationPair $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TranslationPair) {
            throw new \InvalidArgumentException(sprintf('The Translations property can only contain items of \StructType\TranslationPair, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Translations[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TranslationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
