<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TranslationPair StructType
 * @subpackage Structs
 */
class TranslationPair extends AbstractStructBase
{
    /**
     * The Key
     * @var string
     */
    public $Key;
    /**
     * The Translation
     * @var string
     */
    public $Translation;
    /**
     * Constructor method for TranslationPair
     * @uses TranslationPair::setKey()
     * @uses TranslationPair::setTranslation()
     * @param string $key
     * @param string $translation
     */
    public function __construct($key = null, $translation = null)
    {
        $this
            ->setKey($key)
            ->setTranslation($translation);
    }
    /**
     * Get Key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \StructType\TranslationPair
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Translation value
     * @return string|null
     */
    public function getTranslation()
    {
        return $this->Translation;
    }
    /**
     * Set Translation value
     * @param string $translation
     * @return \StructType\TranslationPair
     */
    public function setTranslation($translation = null)
    {
        // validation for constraint: string
        if (!is_null($translation) && !is_string($translation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($translation)), __LINE__);
        }
        $this->Translation = $translation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TranslationPair
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
