<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceCollection StructType
 * @subpackage Structs
 */
class PriceCollection extends AbstractStructBase
{
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Client;
    /**
     * The New
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $New;
    /**
     * The Export
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Export;
    /**
     * The Dealer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Dealer;
    /**
     * The Site
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Site;
    /**
     * The Buy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Buy;
    /**
     * The Sell
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Sell;
    /**
     * The Vat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Vat;
    /**
     * The DestCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $DestCharge;
    /**
     * Constructor method for PriceCollection
     * @uses PriceCollection::setClient()
     * @uses PriceCollection::setNew()
     * @uses PriceCollection::setExport()
     * @uses PriceCollection::setDealer()
     * @uses PriceCollection::setSite()
     * @uses PriceCollection::setBuy()
     * @uses PriceCollection::setSell()
     * @uses PriceCollection::setVat()
     * @uses PriceCollection::setDestCharge()
     * @param float $client
     * @param float $new
     * @param float $export
     * @param float $dealer
     * @param float $site
     * @param float $buy
     * @param float $sell
     * @param bool $vat
     * @param float $destCharge
     */
    public function __construct($client = null, $new = null, $export = null, $dealer = null, $site = null, $buy = null, $sell = null, $vat = null, $destCharge = null)
    {
        $this
            ->setClient($client)
            ->setNew($new)
            ->setExport($export)
            ->setDealer($dealer)
            ->setSite($site)
            ->setBuy($buy)
            ->setSell($sell)
            ->setVat($vat)
            ->setDestCharge($destCharge);
    }
    /**
     * Get Client value
     * @return float|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param float $client
     * @return \StructType\PriceCollection
     */
    public function setClient($client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get New value
     * @return float|null
     */
    public function getNew()
    {
        return $this->New;
    }
    /**
     * Set New value
     * @param float $new
     * @return \StructType\PriceCollection
     */
    public function setNew($new = null)
    {
        $this->New = $new;
        return $this;
    }
    /**
     * Get Export value
     * @return float|null
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param float $export
     * @return \StructType\PriceCollection
     */
    public function setExport($export = null)
    {
        $this->Export = $export;
        return $this;
    }
    /**
     * Get Dealer value
     * @return float|null
     */
    public function getDealer()
    {
        return $this->Dealer;
    }
    /**
     * Set Dealer value
     * @param float $dealer
     * @return \StructType\PriceCollection
     */
    public function setDealer($dealer = null)
    {
        $this->Dealer = $dealer;
        return $this;
    }
    /**
     * Get Site value
     * @return float|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param float $site
     * @return \StructType\PriceCollection
     */
    public function setSite($site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Buy value
     * @return float|null
     */
    public function getBuy()
    {
        return $this->Buy;
    }
    /**
     * Set Buy value
     * @param float $buy
     * @return \StructType\PriceCollection
     */
    public function setBuy($buy = null)
    {
        $this->Buy = $buy;
        return $this;
    }
    /**
     * Get Sell value
     * @return float|null
     */
    public function getSell()
    {
        return $this->Sell;
    }
    /**
     * Set Sell value
     * @param float $sell
     * @return \StructType\PriceCollection
     */
    public function setSell($sell = null)
    {
        $this->Sell = $sell;
        return $this;
    }
    /**
     * Get Vat value
     * @return bool|null
     */
    public function getVat()
    {
        return $this->Vat;
    }
    /**
     * Set Vat value
     * @param bool $vat
     * @return \StructType\PriceCollection
     */
    public function setVat($vat = null)
    {
        $this->Vat = $vat;
        return $this;
    }
    /**
     * Get DestCharge value
     * @return float|null
     */
    public function getDestCharge()
    {
        return $this->DestCharge;
    }
    /**
     * Set DestCharge value
     * @param float $destCharge
     * @return \StructType\PriceCollection
     */
    public function setDestCharge($destCharge = null)
    {
        $this->DestCharge = $destCharge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
