<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LanguagesValues StructType
 * @subpackage Structs
 */
class LanguagesValues extends AbstractStructBase
{
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LanguageType[]
     */
    public $Language;
    /**
     * Constructor method for LanguagesValues
     * @uses LanguagesValues::setLanguage()
     * @param \StructType\LanguageType[] $language
     */
    public function __construct(array $language = array())
    {
        $this
            ->setLanguage($language);
    }
    /**
     * Get Language value
     * @return \StructType\LanguageType[]|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @throws \InvalidArgumentException
     * @param \StructType\LanguageType[] $language
     * @return \StructType\LanguagesValues
     */
    public function setLanguage(array $language = array())
    {
        foreach ($language as $languagesValuesLanguageItem) {
            // validation for constraint: itemType
            if (!$languagesValuesLanguageItem instanceof \StructType\LanguageType) {
                throw new \InvalidArgumentException(sprintf('The Language property can only contain items of \StructType\LanguageType, "%s" given', is_object($languagesValuesLanguageItem) ? get_class($languagesValuesLanguageItem) : gettype($languagesValuesLanguageItem)), __LINE__);
            }
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Add item to Language value
     * @throws \InvalidArgumentException
     * @param \StructType\LanguageType $item
     * @return \StructType\LanguagesValues
     */
    public function addToLanguage(\StructType\LanguageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LanguageType) {
            throw new \InvalidArgumentException(sprintf('The Language property can only contain items of \StructType\LanguageType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Language[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LanguagesValues
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
