<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelValues StructType
 * @subpackage Structs
 */
class LabelValues extends AbstractStructBase
{
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Label;
    /**
     * Constructor method for LabelValues
     * @uses LabelValues::setLabel()
     * @param string[] $label
     */
    public function __construct(array $label = array())
    {
        $this
            ->setLabel($label);
    }
    /**
     * Get Label value
     * @return string[]|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @throws \InvalidArgumentException
     * @param string[] $label
     * @return \StructType\LabelValues
     */
    public function setLabel(array $label = array())
    {
        foreach ($label as $labelValuesLabelItem) {
            // validation for constraint: itemType
            if (!is_string($labelValuesLabelItem)) {
                throw new \InvalidArgumentException(sprintf('The Label property can only contain items of string, "%s" given', is_object($labelValuesLabelItem) ? get_class($labelValuesLabelItem) : gettype($labelValuesLabelItem)), __LINE__);
            }
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Add item to Label value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\LabelValues
     */
    public function addToLabel($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Label property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Label[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LabelValues
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
