<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Do ServiceType
 * @subpackage Services
 */
class _Do extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named doVehicleFilterView
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FilterCollection $filter
     * @param \StructType\FieldsCollection $fields
     * @param string $start
     * @param string $limit
     * @param string $orderField
     * @param string $orderType
     * @return array|bool
     */
    public function doVehicleFilterView(\StructType\FilterCollection $filter, \StructType\FieldsCollection $fields, $start, $limit, $orderField, $orderType)
    {
        try {
            $this->setResult(self::getSoapClient()->doVehicleFilterView($filter, $fields, $start, $limit, $orderField, $orderType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named doVehicleFieldGroupView
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $fieldName
     * @param \StructType\FilterCollection $filter
     * @return \StructType\FieldValues|bool
     */
    public function doVehicleFieldGroupView($fieldName, \StructType\FilterCollection $filter)
    {
        try {
            $this->setResult(self::getSoapClient()->doVehicleFieldGroupView($fieldName, $filter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array|\StructType\FieldValues
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
