<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UVCollection StructType
 * @subpackage Structs
 */
class UVCollection extends AbstractStructBase
{
    /**
     * The OHours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OHours;
    /**
     * The Axes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Axes;
    /**
     * The Springing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Springing;
    /**
     * The Tyres
     * Meta informations extracted from the WSDL
     * - documentation: Freeform Tyres Data
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tyres;
    /**
     * Constructor method for UVCollection
     * @uses UVCollection::setOHours()
     * @uses UVCollection::setAxes()
     * @uses UVCollection::setSpringing()
     * @uses UVCollection::setTyres()
     * @param int $oHours
     * @param int $axes
     * @param int $springing
     * @param string $tyres
     */
    public function __construct($oHours = null, $axes = null, $springing = null, $tyres = null)
    {
        $this
            ->setOHours($oHours)
            ->setAxes($axes)
            ->setSpringing($springing)
            ->setTyres($tyres);
    }
    /**
     * Get OHours value
     * @return int|null
     */
    public function getOHours()
    {
        return $this->OHours;
    }
    /**
     * Set OHours value
     * @param int $oHours
     * @return \StructType\UVCollection
     */
    public function setOHours($oHours = null)
    {
        // validation for constraint: int
        if (!is_null($oHours) && !is_numeric($oHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oHours)), __LINE__);
        }
        $this->OHours = $oHours;
        return $this;
    }
    /**
     * Get Axes value
     * @return int|null
     */
    public function getAxes()
    {
        return $this->Axes;
    }
    /**
     * Set Axes value
     * @param int $axes
     * @return \StructType\UVCollection
     */
    public function setAxes($axes = null)
    {
        // validation for constraint: int
        if (!is_null($axes) && !is_numeric($axes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($axes)), __LINE__);
        }
        $this->Axes = $axes;
        return $this;
    }
    /**
     * Get Springing value
     * @return int|null
     */
    public function getSpringing()
    {
        return $this->Springing;
    }
    /**
     * Set Springing value
     * @param int $springing
     * @return \StructType\UVCollection
     */
    public function setSpringing($springing = null)
    {
        // validation for constraint: int
        if (!is_null($springing) && !is_numeric($springing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($springing)), __LINE__);
        }
        $this->Springing = $springing;
        return $this;
    }
    /**
     * Get Tyres value
     * @return string|null
     */
    public function getTyres()
    {
        return $this->Tyres;
    }
    /**
     * Set Tyres value
     * @param string $tyres
     * @return \StructType\UVCollection
     */
    public function setTyres($tyres = null)
    {
        // validation for constraint: string
        if (!is_null($tyres) && !is_string($tyres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tyres)), __LINE__);
        }
        $this->Tyres = $tyres;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UVCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
