<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketsCollection StructType
 * @subpackage Structs
 */
class MarketsCollection extends AbstractStructBase
{
    /**
     * The Market
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MarketType[]
     */
    public $Market;
    /**
     * The LastExport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastExport;
    /**
     * Constructor method for MarketsCollection
     * @uses MarketsCollection::setMarket()
     * @uses MarketsCollection::setLastExport()
     * @param \StructType\MarketType[] $market
     * @param string $lastExport
     */
    public function __construct(array $market = array(), $lastExport = null)
    {
        $this
            ->setMarket($market)
            ->setLastExport($lastExport);
    }
    /**
     * Get Market value
     * @return \StructType\MarketType[]|null
     */
    public function getMarket()
    {
        return $this->Market;
    }
    /**
     * Set Market value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketType[] $market
     * @return \StructType\MarketsCollection
     */
    public function setMarket(array $market = array())
    {
        foreach ($market as $marketsCollectionMarketItem) {
            // validation for constraint: itemType
            if (!$marketsCollectionMarketItem instanceof \StructType\MarketType) {
                throw new \InvalidArgumentException(sprintf('The Market property can only contain items of \StructType\MarketType, "%s" given', is_object($marketsCollectionMarketItem) ? get_class($marketsCollectionMarketItem) : gettype($marketsCollectionMarketItem)), __LINE__);
            }
        }
        $this->Market = $market;
        return $this;
    }
    /**
     * Add item to Market value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketType $item
     * @return \StructType\MarketsCollection
     */
    public function addToMarket(\StructType\MarketType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketType) {
            throw new \InvalidArgumentException(sprintf('The Market property can only contain items of \StructType\MarketType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Market[] = $item;
        return $this;
    }
    /**
     * Get LastExport value
     * @return string|null
     */
    public function getLastExport()
    {
        return $this->LastExport;
    }
    /**
     * Set LastExport value
     * @param string $lastExport
     * @return \StructType\MarketsCollection
     */
    public function setLastExport($lastExport = null)
    {
        // validation for constraint: string
        if (!is_null($lastExport) && !is_string($lastExport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastExport)), __LINE__);
        }
        $this->LastExport = $lastExport;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MarketsCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
